/*
 * Decompiled with CFR 0.152.
 */
package strikt.java;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import strikt.api.Assertion;
import strikt.api.AtomicAssertion;
import strikt.java.PathKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a0\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a+\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a+\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\fH\u0086\u0004\u001a;\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\b\u0002\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u001b\u001a \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a;\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\b\u0002\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u001b\u001a \u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a \u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a;\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\b\u0002\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u001b\u001a \u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\u001a+\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a+\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\fH\u0086\u0004\u001a+\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a+\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\fH\u0086\u0004\u001a \u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u0001\"+\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"-\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"+\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\u00a8\u0006&"}, d2={"fileName", "Lstrikt/api/Assertion$Builder;", "Ljava/nio/file/Path;", "T", "getFileName", "(Lstrikt/api/Assertion$Builder;)Lstrikt/api/Assertion$Builder;", "parent", "getParent", "size", "", "getSize", "descriptionForOptions", "", "description", "options", "", "Ljava/nio/file/LinkOption;", "(Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/lang/String;", "allBytes", "", "allLines", "", "charset", "Ljava/nio/charset/Charset;", "endsWith", "other", "exists", "(Lstrikt/api/Assertion$Builder;[Ljava/nio/file/LinkOption;)Lstrikt/api/Assertion$Builder;", "isAbsolute", "isDirectory", "isExecutable", "isReadable", "isRegularFile", "isSymbolicLink", "resolve", "startsWith", "toFile", "Ljava/io/File;", "strikt-jvm"})
public final class PathKt {
    @NotNull
    public static final <T extends Path> Assertion.Builder<T> endsWith(@NotNull Assertion.Builder<T> $this$endsWith, @NotNull Path other) {
        Intrinsics.checkNotNullParameter($this$endsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$endsWith.assert("ends with %s", (Object)other, new Function2<AtomicAssertion, T, Unit>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
                super(2);
            }

            public final void invoke(@NotNull AtomicAssertion $this$assert, @NotNull T it) {
                Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"$this$assert");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.endsWith(this.$other)) {
                    AtomicAssertion.pass$default((AtomicAssertion)$this$assert, it, null, (int)2, null);
                } else {
                    AtomicAssertion.fail$default((AtomicAssertion)$this$assert, it, null, null, (int)6, null);
                }
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> endsWith(@NotNull Assertion.Builder<T> $this$endsWith, @NotNull String other) {
        Intrinsics.checkNotNullParameter($this$endsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$endsWith.assert("ends with %s", (Object)other, new Function2<AtomicAssertion, T, Unit>(other){
            final /* synthetic */ String $other;
            {
                this.$other = $other;
                super(2);
            }

            public final void invoke(@NotNull AtomicAssertion $this$assert, @NotNull T it) {
                Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"$this$assert");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.endsWith(this.$other)) {
                    AtomicAssertion.pass$default((AtomicAssertion)$this$assert, it, null, (int)2, null);
                } else {
                    AtomicAssertion.fail$default((AtomicAssertion)$this$assert, it, null, null, (int)6, null);
                }
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<Path> getFileName(@NotNull Assertion.Builder<T> $this$fileName) {
        Intrinsics.checkNotNullParameter($this$fileName, (String)"<this>");
        return (Assertion.Builder)$this$fileName.get("file name", (Function1)fileName.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isAbsolute(@NotNull Assertion.Builder<T> $this$isAbsolute) {
        Intrinsics.checkNotNullParameter($this$isAbsolute, (String)"<this>");
        return $this$isAbsolute.assertThat("is absolute", (Function1)isAbsolute.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<Path> getParent(@NotNull Assertion.Builder<T> $this$parent) {
        Intrinsics.checkNotNullParameter($this$parent, (String)"<this>");
        return (Assertion.Builder)$this$parent.get("parent", (Function1)parent.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<Path> resolve(@NotNull Assertion.Builder<T> $this$resolve, @NotNull Path other) {
        Intrinsics.checkNotNullParameter($this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Assertion.Builder)$this$resolve.get(Intrinsics.stringPlus((String)"resolved against ", (Object)other), new Function1<T, Path>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull T $this$get) {
                Intrinsics.checkNotNullParameter($this$get, (String)"$this$get");
                Path path = $this$get.resolve(this.$other);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(other)");
                return path;
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<Path> resolve(@NotNull Assertion.Builder<T> $this$resolve, @NotNull String other) {
        Intrinsics.checkNotNullParameter($this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Assertion.Builder)$this$resolve.get(Intrinsics.stringPlus((String)"resolved against ", (Object)other), new Function1<T, Path>(other){
            final /* synthetic */ String $other;
            {
                this.$other = $other;
                super(1);
            }

            @NotNull
            public final Path invoke(@NotNull T $this$get) {
                Intrinsics.checkNotNullParameter($this$get, (String)"$this$get");
                Path path = $this$get.resolve(this.$other);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(other)");
                return path;
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> startsWith(@NotNull Assertion.Builder<T> $this$startsWith, @NotNull Path other) {
        Intrinsics.checkNotNullParameter($this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$startsWith.assertThat("starts with %s", (Object)other, new Function1<T, Boolean>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.startsWith(this.$other);
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> startsWith(@NotNull Assertion.Builder<T> $this$startsWith, @NotNull String other) {
        Intrinsics.checkNotNullParameter($this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$startsWith.assertThat("starts with %s", (Object)other, new Function1<T, Boolean>(other){
            final /* synthetic */ String $other;
            {
                this.$other = $other;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.startsWith(this.$other);
            }
        });
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<File> toFile(@NotNull Assertion.Builder<T> $this$toFile) {
        Intrinsics.checkNotNullParameter($this$toFile, (String)"<this>");
        return (Assertion.Builder)$this$toFile.get("as File", (Function1)toFile.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> exists(@NotNull Assertion.Builder<T> $this$exists, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$exists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return $this$exists.assertThat(PathKt.descriptionForOptions("exists", options), new Function1<T, Boolean>(options){
            final /* synthetic */ LinkOption[] $options;
            {
                this.$options = $options;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Files.exists(it, Arrays.copyOf(this.$options, this.$options.length));
            }
        });
    }

    public static /* synthetic */ Assertion.Builder exists$default(Assertion.Builder builder, LinkOption[] linkOptionArray, int n, Object object) {
        if ((n & 1) != 0) {
            boolean $i$f$emptyArray = false;
            linkOptionArray = new LinkOption[]{};
        }
        return PathKt.exists(builder, linkOptionArray);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isDirectory(@NotNull Assertion.Builder<T> $this$isDirectory, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$isDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return $this$isDirectory.assertThat(PathKt.descriptionForOptions("is directory", options), new Function1<T, Boolean>(options){
            final /* synthetic */ LinkOption[] $options;
            {
                this.$options = $options;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Files.isDirectory(it, Arrays.copyOf(this.$options, this.$options.length));
            }
        });
    }

    public static /* synthetic */ Assertion.Builder isDirectory$default(Assertion.Builder builder, LinkOption[] linkOptionArray, int n, Object object) {
        if ((n & 1) != 0) {
            boolean $i$f$emptyArray = false;
            linkOptionArray = new LinkOption[]{};
        }
        return PathKt.isDirectory(builder, linkOptionArray);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isExecutable(@NotNull Assertion.Builder<T> $this$isExecutable) {
        Intrinsics.checkNotNullParameter($this$isExecutable, (String)"<this>");
        return $this$isExecutable.assertThat("is executable", (Function1)isExecutable.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isReadable(@NotNull Assertion.Builder<T> $this$isReadable) {
        Intrinsics.checkNotNullParameter($this$isReadable, (String)"<this>");
        return $this$isReadable.assertThat("is readable", (Function1)isReadable.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isRegularFile(@NotNull Assertion.Builder<T> $this$isRegularFile, LinkOption ... options) {
        Intrinsics.checkNotNullParameter($this$isRegularFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return $this$isRegularFile.assertThat(PathKt.descriptionForOptions("is regular file", options), new Function1<T, Boolean>(options){
            final /* synthetic */ LinkOption[] $options;
            {
                this.$options = $options;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Files.isRegularFile(it, Arrays.copyOf(this.$options, this.$options.length));
            }
        });
    }

    public static /* synthetic */ Assertion.Builder isRegularFile$default(Assertion.Builder builder, LinkOption[] linkOptionArray, int n, Object object) {
        if ((n & 1) != 0) {
            boolean $i$f$emptyArray = false;
            linkOptionArray = new LinkOption[]{};
        }
        return PathKt.isRegularFile(builder, linkOptionArray);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<T> isSymbolicLink(@NotNull Assertion.Builder<T> $this$isSymbolicLink) {
        Intrinsics.checkNotNullParameter($this$isSymbolicLink, (String)"<this>");
        return $this$isSymbolicLink.assertThat("is symbolic lnk", (Function1)isSymbolicLink.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<byte[]> allBytes(@NotNull Assertion.Builder<T> $this$allBytes) {
        Intrinsics.checkNotNullParameter($this$allBytes, (String)"<this>");
        return (Assertion.Builder)$this$allBytes.get("all bytes", (Function1)allBytes.1.INSTANCE);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<List<String>> allLines(@NotNull Assertion.Builder<T> $this$allLines, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$allLines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return (Assertion.Builder)$this$allLines.get("all lines (" + charset + " encoding)", new Function1<T, List<? extends String>>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull T $this$get) {
                Intrinsics.checkNotNullParameter($this$get, (String)"$this$get");
                List<String> list = Files.readAllLines($this$get, this.$charset);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(this, charset)");
                return list;
            }
        });
    }

    public static /* synthetic */ Assertion.Builder allLines$default(Assertion.Builder builder, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathKt.allLines(builder, charset);
    }

    @NotNull
    public static final <T extends Path> Assertion.Builder<Long> getSize(@NotNull Assertion.Builder<T> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return (Assertion.Builder)$this$size.get("size (in bytes)", (Function1)size.1.INSTANCE);
    }

    private static final String descriptionForOptions(String description, LinkOption[] options) {
        String string;
        if (!(options.length == 0)) {
            StringBuilder stringBuilder = new StringBuilder().append(description).append(" with options ");
            String string2 = Arrays.toString(options);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
            string = stringBuilder.append(string2).toString();
        } else {
            string = description;
        }
        return string;
    }
}

