package strikt.internal.opentest4j

import org.opentest4j.IncompleteExecutionException

/**
 * Thrown to indicate that a mapping function such as
 * [strikt.api.Assertion.Builder.get] or [strikt.api.Assertion.Builder.with]
 * failed due to an exception thrown by the mapping function.
 */
class MappingFailed(description: String, cause: Throwable) :
  IncompleteExecutionException(
    "Mapping '$description' failed with: ${cause.message}",
    cause
  )
