/*
 * Decompiled with CFR 0.152.
 */
package strikt.internal.reporting;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import strikt.internal.ComparedValues;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"FORMATTED_VALUE_MAX_LENGTH", "", "hexArray", "", "formatValue", "", "value", "formatValues", "Lstrikt/internal/ComparedValues;", "preferToString", "", "Ljava/lang/Class;", "toHex", "", "", "truncate", "", "maxLength", "withTypeSuffix", "typeOf", "strikt-core"})
public final class FormattingKt {
    private static final char[] hexArray;
    public static final int FORMATTED_VALUE_MAX_LENGTH = 40;

    @NotNull
    public static final ComparedValues formatValues(@NotNull ComparedValues $this$formatValues) {
        Intrinsics.checkNotNullParameter((Object)$this$formatValues, (String)"$this$formatValues");
        Object e = FormattingKt.formatValue($this$formatValues.getExpected());
        Object a = FormattingKt.formatValue($this$formatValues.getActual());
        return Intrinsics.areEqual((Object)e.toString(), (Object)a.toString()) ? new ComparedValues(FormattingKt.withTypeSuffix(e, $this$formatValues.getExpected()), FormattingKt.withTypeSuffix(a, $this$formatValues.getActual())) : new ComparedValues(e, a);
    }

    private static final Object withTypeSuffix(Object $this$withTypeSuffix, Object typeOf) {
        Object object = typeOf;
        return object == null ? $this$withTypeSuffix : $this$withTypeSuffix + " (" + JvmClassMappingKt.getKotlinClass(typeOf.getClass()).getSimpleName() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object formatValue(@Nullable Object value) {
        Object object;
        Object object2 = value;
        if (object2 == null) {
            object = "null";
        } else if (object2 instanceof CharSequence) {
            object = "" + '\"' + value + '\"';
        } else if (object2 instanceof Character) {
            object = "" + '\'' + value + '\'';
        } else if (object2 instanceof Iterable) {
            if (FormattingKt.preferToString(((Iterable)value).getClass())) {
                object = value.toString();
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void p1;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object object3 = FormattingKt.formatValue(p1);
                    collection.add(object3);
                }
                object = (List)destination$iv$iv;
            }
        } else if (object2 instanceof Byte) {
            StringBuilder stringBuilder = new StringBuilder().append("0x");
            byte $this$map$iv = ((Number)value).byteValue();
            int $i$f$map = 16;
            boolean $this$mapTo$iv$iv = false;
            byte destination$iv$iv = $this$map$iv;
            int $i$f$mapTo = CharsKt.checkRadix((int)$i$f$map);
            boolean bl = false;
            String string = Integer.toString(destination$iv$iv, CharsKt.checkRadix((int)$i$f$mapTo));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            object = stringBuilder.append(string).toString();
        } else if (object2 instanceof byte[]) {
            object = FormattingKt.truncate$default("0x" + FormattingKt.toHex((byte[])value), 0, 1, null);
        } else if (object2 instanceof char[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((char[])((char[])value)));
        } else if (object2 instanceof short[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((short[])((short[])value)));
        } else if (object2 instanceof int[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((int[])((int[])value)));
        } else if (object2 instanceof long[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((long[])((long[])value)));
        } else if (object2 instanceof float[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((float[])((float[])value)));
        } else if (object2 instanceof double[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((double[])((double[])value)));
        } else if (object2 instanceof Object[]) {
            object = FormattingKt.formatValue(ArraysKt.toList((Object[])((Object[])value)));
        } else if (object2 instanceof Class) {
            String string = ((Class)value).getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.name");
        } else if (object2 instanceof Regex) {
            object = '/' + ((Regex)value).getPattern() + '/';
        } else if (object2 instanceof Throwable) {
            String string = ((Throwable)value).getClass().getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.javaClass.name");
        } else if (object2 instanceof CallableReference) {
            object = FormattingKt.formatValue(((CallableReference)value).getBoundReceiver()) + "::" + ((CallableReference)value).getName();
        } else if (object2 instanceof Pair) {
            object = "" + '{' + FormattingKt.formatValue(((Pair)value).getFirst()) + ": " + FormattingKt.formatValue(((Pair)value).getSecond()) + '}';
        } else if (object2 instanceof Map) {
            Map $this$map$iv = (Map)value;
            boolean $i$f$map = false;
            Map $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Map map2 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void k;
                void $dstr$k$v;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_32 = $dstr$k$v;
                boolean bl3 = false;
                Object k2 = var13_32.getKey();
                var13_32 = $dstr$k$v;
                bl3 = false;
                Object v = var13_32.getValue();
                Pair pair = TuplesKt.to((Object)FormattingKt.formatValue(k), (Object)FormattingKt.formatValue(v));
                collection.add(pair);
            }
            object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            object = object2 instanceof Number ? value : value.toString();
        }
        return object;
    }

    private static final boolean preferToString(Class<?> $this$preferToString) {
        Method method = $this$preferToString.getMethod("toString", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod(\"toString\")");
        return Intrinsics.areEqual(method.getDeclaringClass(), $this$preferToString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"$this$toHex");
        char[] hexChars = new char[$this$toHex.length * 2];
        int n = 0;
        int n2 = $this$toHex.length;
        while (n < n2) {
            void j;
            int v = $this$toHex[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + true] = hexArray[v & 0xF];
            ++j;
        }
        n = 0;
        return new String(hexChars);
    }

    private static final CharSequence truncate(CharSequence $this$truncate, int maxLength) {
        CharSequence charSequence;
        int n = $this$truncate.length();
        int n2 = n;
        if (0 <= n2 && maxLength >= n2) {
            charSequence = $this$truncate;
        } else {
            CharSequence charSequence2 = $this$truncate;
            int n3 = 0;
            boolean bl = false;
            charSequence = ((Object)charSequence2.subSequence(n3, maxLength)).toString() + "\u2026";
        }
        return charSequence;
    }

    static /* synthetic */ CharSequence truncate$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 40;
        }
        return FormattingKt.truncate(charSequence, n);
    }

    static {
        String string = "0123456789ABCDEF";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        hexArray = cArray;
    }
}

