/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.filesystem.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.LedgerOffloaderStats;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBackedReadHandleImpl
implements ReadHandle {
    private static final Logger log = LoggerFactory.getLogger(FileStoreBackedReadHandleImpl.class);
    private final ExecutorService executor;
    private final MapFile.Reader reader;
    private final long ledgerId;
    private final LedgerMetadata ledgerMetadata;
    private final LedgerOffloaderStats offloaderStats;
    private final String managedLedgerName;

    private FileStoreBackedReadHandleImpl(ExecutorService executor, MapFile.Reader reader, long ledgerId, LedgerOffloaderStats offloaderStats, String managedLedgerName) throws IOException {
        this.ledgerId = ledgerId;
        this.executor = executor;
        this.reader = reader;
        this.offloaderStats = offloaderStats;
        this.managedLedgerName = managedLedgerName;
        LongWritable key = new LongWritable();
        BytesWritable value = new BytesWritable();
        try {
            key.set(-1L);
            long startReadIndexTime = System.nanoTime();
            reader.get((WritableComparable)key, (Writable)value);
            offloaderStats.recordReadOffloadIndexLatency(managedLedgerName, System.nanoTime() - startReadIndexTime, TimeUnit.NANOSECONDS);
            this.ledgerMetadata = OffloadUtils.parseLedgerMetadata((long)ledgerId, (byte[])value.copyBytes());
        }
        catch (IOException e) {
            log.error("Fail to read LedgerMetadata for ledgerId {}", (Object)ledgerId);
            throw new IOException("Fail to read LedgerMetadata for ledgerId " + key.get());
        }
    }

    public long getId() {
        return this.ledgerId;
    }

    public LedgerMetadata getLedgerMetadata() {
        return this.ledgerMetadata;
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.reader.close();
            }
            catch (IOException t) {
                promise.completeExceptionally(t);
            }
        });
        return promise;
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        if (log.isDebugEnabled()) {
            log.debug("Ledger {}: reading {} - {}", new Object[]{this.getId(), firstEntry, lastEntry});
        }
        CompletableFuture<LedgerEntries> promise = new CompletableFuture<LedgerEntries>();
        this.executor.submit(() -> {
            if (firstEntry > lastEntry || firstEntry < 0L || lastEntry > this.getLastAddConfirmed()) {
                promise.completeExceptionally((Throwable)new BKException.BKIncorrectParameterException());
                return;
            }
            long entriesToRead = lastEntry - firstEntry + 1L;
            ArrayList<LedgerEntryImpl> entries = new ArrayList<LedgerEntryImpl>();
            long nextExpectedId = firstEntry;
            LongWritable key = new LongWritable();
            BytesWritable value = new BytesWritable();
            try {
                key.set(nextExpectedId - 1L);
                this.reader.seek((WritableComparable)key);
                while (entriesToRead > 0L) {
                    long startReadTime = System.nanoTime();
                    this.reader.next((WritableComparable)key, (Writable)value);
                    this.offloaderStats.recordReadOffloadDataLatency(this.managedLedgerName, System.nanoTime() - startReadTime, TimeUnit.NANOSECONDS);
                    int length = value.getLength();
                    long entryId = key.get();
                    if (entryId == nextExpectedId) {
                        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(length, length);
                        entries.add(LedgerEntryImpl.create((long)this.ledgerId, (long)entryId, (long)length, (ByteBuf)buf));
                        buf.writeBytes(value.copyBytes());
                        --entriesToRead;
                        ++nextExpectedId;
                        this.offloaderStats.recordReadOffloadBytes(this.managedLedgerName, (long)length);
                        continue;
                    }
                    if (entryId <= lastEntry) continue;
                    log.info("Expected to read {}, but read {}, which is greater than last entry {}", new Object[]{nextExpectedId, entryId, lastEntry});
                    throw new BKException.BKUnexpectedConditionException();
                }
                promise.complete((LedgerEntries)LedgerEntriesImpl.create(entries));
            }
            catch (Throwable t) {
                this.offloaderStats.recordReadOffloadError(this.managedLedgerName);
                promise.completeExceptionally(t);
                entries.forEach(LedgerEntry::close);
            }
        });
        return promise;
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return CompletableFuture.completedFuture(this.getLastAddConfirmed());
    }

    public long getLastAddConfirmed() {
        return this.getLedgerMetadata().getLastEntryId();
    }

    public long getLength() {
        return this.getLedgerMetadata().getLength();
    }

    public boolean isClosed() {
        return this.getLedgerMetadata().isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        CompletableFuture<LastConfirmedAndEntry> promise = new CompletableFuture<LastConfirmedAndEntry>();
        promise.completeExceptionally(new UnsupportedOperationException());
        return promise;
    }

    public static ReadHandle open(ScheduledExecutorService executor, MapFile.Reader reader, long ledgerId, LedgerOffloaderStats offloaderStats, String managedLedgerName) throws IOException {
        return new FileStoreBackedReadHandleImpl(executor, reader, ledgerId, offloaderStats, managedLedgerName);
    }
}

