/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.rpc;

import io.grpc.stub.StreamObserver;
import org.bookkeeper.tests.proto.rpc.PingPongServiceGrpc;
import org.bookkeeper.tests.proto.rpc.PingRequest;
import org.bookkeeper.tests.proto.rpc.PongResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingPongService
extends PingPongServiceGrpc.PingPongServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(PingPongService.class);
    private final int streamPongSize;

    public PingPongService(int streamPongSize) {
        this.streamPongSize = streamPongSize;
    }

    @Override
    public void pingPong(PingRequest request, StreamObserver<PongResponse> responseObserver) {
        responseObserver.onNext((Object)PongResponse.newBuilder().setLastSequence(request.getSequence()).setNumPingReceived(1).setSlotId(0).build());
        responseObserver.onCompleted();
    }

    @Override
    public StreamObserver<PingRequest> lotsOfPings(final StreamObserver<PongResponse> responseObserver) {
        return new StreamObserver<PingRequest>(){
            int pingCount = 0;
            long lastSequence = -1L;

            public void onNext(PingRequest value) {
                ++this.pingCount;
                this.lastSequence = value.getSequence();
            }

            public void onError(Throwable t) {
                log.error("Failed on receiving stream of pings", t);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)PongResponse.newBuilder().setNumPingReceived(this.pingCount).setLastSequence(this.lastSequence).setSlotId(0).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    public void lotsOfPongs(PingRequest request, StreamObserver<PongResponse> responseObserver) {
        long sequence = request.getSequence();
        for (int i = 0; i < this.streamPongSize; ++i) {
            responseObserver.onNext((Object)PongResponse.newBuilder().setLastSequence(sequence).setNumPingReceived(1).setSlotId(i).build());
        }
        responseObserver.onCompleted();
    }

    @Override
    public StreamObserver<PingRequest> bidiPingPong(final StreamObserver<PongResponse> responseObserver) {
        return new StreamObserver<PingRequest>(){
            int pingCount = 0;

            public void onNext(PingRequest ping) {
                ++this.pingCount;
                responseObserver.onNext((Object)PongResponse.newBuilder().setLastSequence(ping.getSequence()).setNumPingReceived(this.pingCount).setSlotId(0).build());
            }

            public void onError(Throwable t) {
                responseObserver.onError(t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }
}

