/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final int PULSAR_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    public static final String DEFAULT_IMAGE_NAME = System.getenv().getOrDefault("PULSAR_TEST_IMAGE_NAME", "apachepulsar/pulsar-test-latest-version:latest");

    public PulsarContainer() {
        this(DEFAULT_IMAGE_NAME);
    }

    public PulsarContainer(String pulsarVersion) {
        super(pulsarVersion);
        this.withExposedPorts(new Integer[]{8080, 6650});
        this.withCommand("/pulsar/bin/pulsar standalone");
        this.waitingFor(new HttpWaitStrategy().forPort(8080).forStatusCode(200).forPath("/admin/v2/namespaces/public/default").withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS)));
    }

    public String getPlainTextPulsarBrokerUrl() {
        return String.format("pulsar://%s:%s", this.getHost(), this.getMappedPort(6650));
    }

    public String getPulsarAdminUrl() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }
}

