/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.PulsarContainer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SmokeTest
extends TestRetrySupport {
    private PulsarContainer pulsarContainer;

    @BeforeClass(alwaysRun=true)
    public final void setup() {
        this.incrementSetupNumber();
        this.pulsarContainer = new PulsarContainer();
        this.pulsarContainer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkClient() throws PulsarClientException {
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarContainer.getPlainTextPulsarBrokerUrl()).build();
        try {
            String inputTopic = "input";
            Producer producer = client.newProducer(Schema.STRING).topic("input").enableBatching(false).create();
            Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{"input"}).subscriptionName("test-subs").ackTimeout(10L, TimeUnit.SECONDS).subscriptionType(SubscriptionType.Exclusive).subscribe();
            producer.send((Object)"Hello!");
            Message message = consumer.receive(10, TimeUnit.SECONDS);
            Assert.assertEquals((String)((String)message.getValue()), (String)"Hello!");
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void checkAdmin() throws PulsarClientException, PulsarAdminException {
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarContainer.getPulsarAdminUrl()).build();
        ArrayList<String> expectedNamespacesList = new ArrayList<String>();
        expectedNamespacesList.add("public/default");
        expectedNamespacesList.add("public/functions");
        Assert.assertEquals((Collection)admin.namespaces().getNamespaces("public"), expectedNamespacesList);
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() {
        this.markCurrentSetupNumberCleaned();
        this.pulsarContainer.stop();
    }
}

