/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import java.util.regex.Pattern;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.service.plugin.FilterContext;
import org.apache.pulsar.common.api.proto.KeyValue;

public class PatternEntryFilter
implements EntryFilter {
    public static final String FILTER_PATTERN = "entry_filter_pattern";
    public static final String FILTER_PROPERTY = "filter_property";

    public EntryFilter.FilterResult filterEntry(Entry entry, FilterContext context) {
        Pattern p = this.getPattern(context);
        String value = this.getMessagePropertyValue(context);
        if (p == null || value == null || p.matcher(value).matches()) {
            return EntryFilter.FilterResult.ACCEPT;
        }
        return EntryFilter.FilterResult.REJECT;
    }

    private Pattern getPattern(FilterContext context) {
        String subscriptionRegex = (String)context.getSubscription().getSubscriptionProperties().get(FILTER_PATTERN);
        if (subscriptionRegex == null) {
            return null;
        }
        return Pattern.compile(subscriptionRegex);
    }

    private String getMessagePropertyValue(FilterContext context) {
        return context.getMsgMetadata().getPropertiesList().stream().filter(kv -> FILTER_PROPERTY.equals(kv.getKey())).map(KeyValue::getValue).findFirst().orElse(null);
    }

    public void close() {
    }
}

