/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.client.api.schema.SchemaBuilder;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Source;
import org.apache.pulsar.io.core.SourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRecordSource
implements Source<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(GenericRecordSource.class);
    private RecordSchemaBuilder recordSchemaBuilder;
    private GenericSchema<GenericRecord> schema;
    private List<Field> fields;
    private AtomicInteger count = new AtomicInteger();

    public void open(Map<String, Object> config, SourceContext sourceContext) throws Exception {
        this.recordSchemaBuilder = SchemaBuilder.record((String)"MyBean");
        this.recordSchemaBuilder.field("number").type(SchemaType.INT32);
        this.recordSchemaBuilder.field("text").type(SchemaType.STRING);
        this.schema = Schema.generic((SchemaInfo)this.recordSchemaBuilder.build(SchemaType.AVRO));
        this.fields = Arrays.asList(new Field("number", 0), new Field("text", 1));
        log.info("created source, schema {}", (Object)new String(this.schema.getSchemaInfo().getSchema(), StandardCharsets.UTF_8));
    }

    public Record<GenericRecord> read() throws Exception {
        Thread.sleep(20L);
        int value = this.count.incrementAndGet();
        final GenericRecord record = this.schema.newRecordBuilder().set("number", (Object)value).set("text", (Object)("value-" + value)).build();
        log.info("produced {}", (Object)record);
        return new Record<GenericRecord>(){

            public GenericRecord getValue() {
                return record;
            }

            public Schema<GenericRecord> getSchema() {
                return GenericRecordSource.this.schema;
            }
        };
    }

    public void close() {
    }
}

