/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;

public class TestStateSink
implements Sink<String> {
    private SinkContext sinkContext;
    private int count;

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        sinkContext.putState("initial", ByteBuffer.wrap("val1".getBytes()));
        this.sinkContext = sinkContext;
    }

    public void write(Record<String> record) throws Exception {
        String initial = new String(this.sinkContext.getState("initial").array());
        String val = String.format("%s-%d", initial, this.count);
        this.sinkContext.putState("now", ByteBuffer.wrap(val.getBytes()));
        ++this.count;
    }

    public void close() throws Exception {
    }
}

