/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenericObjectSink
implements Sink<GenericObject> {
    private static final Logger log = LoggerFactory.getLogger(TestGenericObjectSink.class);

    public void open(Map<String, Object> config, SinkContext sourceContext) throws Exception {
    }

    public void write(Record<GenericObject> record) {
        GenericRecord nativeGenericRecord;
        String schemaDefinition;
        log.info("topic {}", record.getTopicName().orElse(null));
        log.info("properties {}", (Object)record.getProperties());
        log.info("received record {} {}", record, record.getClass());
        log.info("schema {}", (Object)record.getSchema());
        log.info("native schema {}", record.getSchema().getNativeSchema().orElse(null));
        log.info("schemaInfo {}", (Object)record.getSchema().getSchemaInfo());
        log.info("schemaInfo.type {}", (Object)record.getSchema().getSchemaInfo().getType());
        String expectedRecordType = record.getProperties().getOrDefault("expectedType", "MISSING");
        log.info("expectedRecordType {}", (Object)expectedRecordType);
        if (!expectedRecordType.equals(record.getSchema().getSchemaInfo().getType().name())) {
            throw new RuntimeException("Unexpected record type " + record.getSchema().getSchemaInfo().getType().name() + " is not " + expectedRecordType);
        }
        log.info("value {}", record.getValue());
        log.info("value schema type {}", (Object)((GenericObject)record.getValue()).getSchemaType());
        log.info("value native object {}", ((GenericObject)record.getValue()).getNativeObject());
        if (record.getSchema().getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)record.getSchema();
            log.info("key schema type {}", (Object)kvSchema.getKeySchema());
            log.info("value schema type {}", (Object)kvSchema.getValueSchema());
            log.info("key encoding {}", (Object)kvSchema.getKeyValueEncodingType());
            KeyValue keyValue = (KeyValue)((GenericObject)record.getValue()).getNativeObject();
            log.info("kvkey {}", keyValue.getKey());
            log.info("kvvalue {}", keyValue.getValue());
        }
        log.info("value {}", record.getValue());
        log.info("value schema type {}", (Object)((GenericObject)record.getValue()).getSchemaType());
        log.info("value native object {} class {}", ((GenericObject)record.getValue()).getNativeObject(), ((GenericObject)record.getValue()).getNativeObject().getClass());
        String expectedSchemaDefinition = record.getProperties().getOrDefault("expectedSchemaDefinition", "");
        log.info("schemaDefinition {}", (Object)record.getSchema().getSchemaInfo().getSchemaDefinition());
        log.info("expectedSchemaDefinition {}", (Object)expectedSchemaDefinition);
        if (!expectedSchemaDefinition.isEmpty() && !expectedSchemaDefinition.equals(schemaDefinition = record.getSchema().getSchemaInfo().getSchemaDefinition())) {
            throw new RuntimeException("Unexpected schema definition " + schemaDefinition + " is not " + expectedSchemaDefinition);
        }
        if (record.getSchema().getSchemaInfo().getType() == SchemaType.AVRO) {
            nativeGenericRecord = (GenericRecord)((GenericObject)record.getValue()).getNativeObject();
            log.info("Schema from AVRO generic object {}", (Object)nativeGenericRecord.getSchema());
        }
        if (record.getSchema().getSchemaInfo().getType() == SchemaType.JSON) {
            nativeGenericRecord = (JsonNode)((GenericObject)record.getValue()).getNativeObject();
            log.info("NodeType from JsonNode generic object {}", (Object)nativeGenericRecord.getNodeType());
        }
        record.ack();
    }

    public void close() throws Exception {
    }
}

