/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.integration.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Frame;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DockerUtils.class);

    private static File getTargetDirectory(String containerId) {
        File directory;
        String base = System.getProperty("maven.buildDirectory");
        if (base == null) {
            base = "target";
        }
        if (!(directory = new File(base + "/container-logs/" + containerId)).exists() && !directory.mkdirs()) {
            LOG.error("Error creating directory for container logs.");
        }
        return directory;
    }

    public static void dumpContainerLogToTarget(DockerClient docker, String containerId) {
        File output = new File(DockerUtils.getTargetDirectory(containerId), "docker.log");
        try (final FileOutputStream os = new FileOutputStream(output);){
            final CompletableFuture future = new CompletableFuture();
            docker.logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback<Frame>(){

                public void close() {
                }

                public void onStart(Closeable closeable) {
                }

                public void onNext(Frame object) {
                    try {
                        os.write(object.getPayload());
                    }
                    catch (IOException e) {
                        this.onError(e);
                    }
                }

                public void onError(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }

                public void onComplete() {
                    future.complete(true);
                }
            });
            future.get();
        }
        catch (IOException | RuntimeException | ExecutionException e) {
            LOG.error("Error dumping log for {}", (Object)containerId, (Object)e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted dumping log from container {}", (Object)containerId, (Object)ie);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public static void dumpContainerDirToTargetCompressed(DockerClient dockerClient, String containerId, String path) {
        int readBlockSize = 10000;
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(containerId).exec();
        String containerName = inspectContainerResponse.getName().replace("/", "");
        File output = new File(DockerUtils.getTargetDirectory(containerName), (path.replace("/", "-") + ".tar.gz").replaceAll("^-", ""));
        try (InputStream dockerStream = dockerClient.copyArchiveFromContainerCmd(containerId, path).exec();
             GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(output));){
            byte[] block = new byte[10000];
            int read = dockerStream.read(block, 0, 10000);
            while (read > -1) {
                ((OutputStream)os).write(block, 0, read);
                read = dockerStream.read(block, 0, 10000);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error reading dir from container {}", (Object)containerName, (Object)e);
        }
    }

    public static void dumpContainerLogDirToTarget(DockerClient docker, String containerId, String path) {
        int readBlockSize = 10000;
        try (InputStream dockerStream = docker.copyArchiveFromContainerCmd(containerId, path).exec();
             TarArchiveInputStream stream = new TarArchiveInputStream(dockerStream);){
            TarArchiveEntry entry = stream.getNextTarEntry();
            while (entry != null) {
                if (entry.isFile()) {
                    File targetDir = DockerUtils.getTargetDirectory(containerId);
                    File output = new File(targetDir, entry.getName().replace("/", "-"));
                    if (!output.toPath().normalize().startsWith(targetDir.toPath())) {
                        throw new IOException("Bad zip entry");
                    }
                    try (FileOutputStream os = new FileOutputStream(output);){
                        byte[] block = new byte[10000];
                        int read = stream.read(block, 0, 10000);
                        while (read > -1) {
                            os.write(block, 0, read);
                            read = stream.read(block, 0, 10000);
                        }
                    }
                }
                entry = stream.getNextTarEntry();
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error reading bk logs from container {}", (Object)containerId, (Object)e);
        }
    }

    public static String getContainerIP(DockerClient docker, String containerId) {
        Iterator iterator = docker.inspectContainerCmd(containerId).exec().getNetworkSettings().getNetworks().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            return ((ContainerNetwork)e.getValue()).getIpAddress();
        }
        throw new IllegalArgumentException("Container " + containerId + " has no networks");
    }

    public static String runCommand(DockerClient docker, String containerId, String ... cmd) throws Exception {
        return DockerUtils.runCommand(docker, containerId, false, cmd);
    }

    public static String runCommand(DockerClient docker, final String containerId, boolean ignoreError, String ... cmd) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        String execid = ((ExecCreateCmdResponse)docker.execCreateCmd(containerId).withCmd(cmd).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).exec()).getId();
        final String cmdString = Arrays.stream(cmd).collect(Collectors.joining(" "));
        final StringBuffer output = new StringBuffer();
        docker.execStartCmd(execid).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ResultCallback<Frame>(){

            public void close() {
            }

            public void onStart(Closeable closeable) {
                LOG.info("DOCKER.exec({}:{}): Executing...", (Object)containerId, (Object)cmdString);
            }

            public void onNext(Frame object) {
                LOG.info("DOCKER.exec({}:{}): {}", new Object[]{containerId, cmdString, object});
                output.append(new String(object.getPayload(), StandardCharsets.UTF_8));
            }

            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                LOG.info("DOCKER.exec({}:{}): Done", (Object)containerId, (Object)cmdString);
                future.complete(true);
            }
        });
        future.get();
        InspectExecResponse resp = docker.inspectExecCmd(execid).exec();
        while (resp.isRunning().booleanValue()) {
            Thread.sleep(200L);
            resp = docker.inspectExecCmd(execid).exec();
        }
        long retCode = resp.getExitCodeLong();
        if (retCode != 0L) {
            LOG.error("DOCKER.exec({}:{}): failed with {} : {}", new Object[]{containerId, cmdString, retCode, output});
            if (!ignoreError) {
                throw new Exception(String.format("cmd(%s) failed on %s with exitcode %d", cmdString, containerId, retCode));
            }
        } else {
            LOG.info("DOCKER.exec({}:{}): completed with {}", new Object[]{containerId, cmdString, retCode});
        }
        return output.toString();
    }

    public static Set<String> cubeIdsMatching(String needle) {
        Pattern pattern = Pattern.compile("^arq.cube.docker.([^.]*).ip$");
        return System.getProperties().keySet().stream().map(k -> pattern.matcher(k.toString())).filter(m -> m.matches()).map(m -> m.group(1)).filter(m -> m.contains(needle)).collect(Collectors.toSet());
    }
}

