/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.integration.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadReaper {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadReaper.class);
    private static AtomicInteger groupId = new AtomicInteger(0);

    public static <T> T runWithReaper(Callable<T> callable) throws Exception {
        ThreadGroup tg = new ThreadGroup("reaper-group-" + groupId.incrementAndGet());
        CompletableFuture promise = new CompletableFuture();
        Thread t = new Thread(tg, () -> {
            try {
                promise.complete(callable.call());
            }
            catch (Throwable ex) {
                promise.completeExceptionally(ex);
            }
        }, "reapable-thread");
        t.start();
        Object ret = promise.get();
        for (int i = 30; tg.activeCount() > 0 && i > 0; --i) {
            tg.interrupt();
            Thread.sleep(100L);
            LOG.info("{} threads still alive", (Object)tg.activeCount());
        }
        if (tg.activeCount() == 0) {
            LOG.info("All threads in reaper group dead");
        } else {
            Thread[] threads = new Thread[tg.activeCount()];
            int found = tg.enumerate(threads);
            LOG.info("Leaked {} threads", (Object)found);
            for (int j = 0; j < found; ++j) {
                LOG.info("Leaked thread {}", (Object)threads[j]);
            }
        }
        return ret;
    }
}

