/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.integration.utils;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.bookkeeper.tests.integration.utils.BookKeeperClusterUtils;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.resolver.api.Coordinate;
import org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClassLoader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MavenClassLoader.class);
    private static ScheduledExecutorService delayedCloseExecutor = MavenClassLoader.createExecutorThatShutsDownIdleThreads();
    private static List<File> currentVersionLibs;
    private final ClassLoader classloader;

    private static ScheduledExecutorService createExecutorThatShutsDownIdleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)((Object)executor);
        poolExecutor.setKeepAliveTime(10L, TimeUnit.SECONDS);
        poolExecutor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private MavenClassLoader(ClassLoader cl) {
        this.classloader = cl;
    }

    public static MavenClassLoader forArtifact(String repo, String mainArtifact) throws Exception {
        return MavenClassLoader.createClassLoader((ConfigurableMavenResolverSystem)Maven.configureResolver().withRemoteRepo("custom", repo, "default"), mainArtifact);
    }

    public static MavenClassLoader forArtifact(String mainArtifact) throws Exception {
        return MavenClassLoader.createClassLoader(Maven.configureResolver(), mainArtifact);
    }

    private static MavenClassLoader createClassLoader(ConfigurableMavenResolverSystem resolver, String mainArtifact) throws Exception {
        Optional<String> slf4jVersion = Arrays.stream(((MavenFormatStage)((MavenStrategyStage)resolver.resolve(mainArtifact)).withTransitivity()).asResolvedArtifact()).filter(a -> a.getCoordinate().getGroupId().equals("org.slf4j")).map(a -> a.getCoordinate().getVersion()).findFirst();
        MavenDependency dependency = MavenDependencies.createDependency((String)mainArtifact, (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[]{MavenDependencies.createExclusion((String)"log4j", (String)"log4j"), MavenDependencies.createExclusion((String)"org.slf4j", (String)"slf4j-log4j12"), MavenDependencies.createExclusion((String)"ch.qos.reload4j", (String)"log4j"), MavenDependencies.createExclusion((String)"org.slf4j", (String)"slf4j-reload4j"), MavenDependencies.createExclusion((String)"org.apache.logging.log4j", (String)"*")});
        ArrayList deps = Lists.newArrayList((Object[])new MavenDependency[]{dependency});
        if (slf4jVersion.isPresent()) {
            deps.add(MavenDependencies.createDependency((String)("org.slf4j:slf4j-simple:" + slf4jVersion.get()), (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]));
            deps.add(MavenDependencies.createDependency((String)("org.slf4j:jcl-over-slf4j:" + slf4jVersion.get()), (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]));
        }
        MavenResolvedArtifact[] resolvedArtifact = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomlessResolveStage)resolver.addDependencies((Coordinate[])deps.toArray(new MavenDependency[0]))).resolve()).withTransitivity()).asResolvedArtifact();
        File[] files = Arrays.stream(resolvedArtifact).filter(a -> {
            MavenCoordinate c = a.getCoordinate();
            if (c.getGroupId().equals("org.apache.logging.log4j") || c.getGroupId().equals("log4j") || c.getGroupId().equals("ch.qos.reload4j") || c.getGroupId().equals("commons-logging")) {
                return false;
            }
            return !c.getArtifactId().contains("log4j") && !c.getArtifactId().contains("commons-logging");
        }).map(ResolvedArtifact::asFile).collect(Collectors.toList()).toArray(new File[0]);
        return MavenClassLoader.createClassLoader(files);
    }

    private static MavenClassLoader createClassLoader(File[] jars) {
        final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        URLClassLoader cl = new URLClassLoader((URL[])Arrays.stream(jars).map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }).toArray(URL[]::new), systemClassLoader){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) {
                    block7: {
                        try {
                            loadedClass = this.findClass(name);
                        }
                        catch (ClassNotFoundException ignored) {
                            if (!name.startsWith("org.apache") && !name.startsWith("org.slf4j") && !name.startsWith("log4j")) break block7;
                            throw ignored;
                        }
                    }
                    if (loadedClass == null) {
                        try {
                            loadedClass = systemClassLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (resolve && loadedClass != null) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
        };
        return new MavenClassLoader(cl);
    }

    public static MavenClassLoader forBookKeeperVersion(String version) throws Exception {
        if (version.equals(BookKeeperClusterUtils.CURRENT_VERSION)) {
            return MavenClassLoader.forBookkeeperCurrentVersion();
        }
        return MavenClassLoader.forArtifact("org.apache.bookkeeper:bookkeeper-server:" + version);
    }

    private static synchronized MavenClassLoader forBookkeeperCurrentVersion() throws Exception {
        if (currentVersionLibs == null) {
            String version = BookKeeperClusterUtils.CURRENT_VERSION;
            String rootDirectory = System.getenv("GITHUB_WORKSPACE");
            if (rootDirectory == null) {
                File gitDirectory = MavenClassLoader.findGitRoot(new File("."));
                rootDirectory = gitDirectory != null ? gitDirectory.getAbsolutePath() : System.getProperty("maven.buildDirectory", ".") + "/../../../..";
            }
            String artifactName = "bookkeeper-server-" + version + "-bin";
            Path tarFile = Paths.get(rootDirectory, "bookkeeper-dist", "server", "target", artifactName + ".tar.gz").toAbsolutePath();
            File tempDir = new File(System.getProperty("maven.buildDirectory", "target"));
            MavenClassLoader.extractTarGz(tarFile.toFile(), tempDir);
            ArrayList<File> jars = new ArrayList<File>();
            Files.list(Paths.get(tempDir.getAbsolutePath(), "bookkeeper-server-" + version, "lib")).forEach(path -> jars.add(path.toFile()));
            currentVersionLibs = jars;
        }
        return MavenClassLoader.createClassLoader(currentVersionLibs.toArray(new File[0]));
    }

    private static File findGitRoot(File currentDir) {
        while (currentDir != null) {
            if (new File(currentDir, ".git").exists()) {
                return currentDir;
            }
            currentDir = currentDir.getParentFile();
        }
        return null;
    }

    public Object callStaticMethod(String className, String methodName, ArrayList<?> args) throws Exception {
        Class<?> klass = Class.forName(className, true, this.classloader);
        try {
            Class[] paramTypes = (Class[])args.stream().map(a -> a.getClass()).toArray(Class[]::new);
            return klass.getMethod(methodName, paramTypes).invoke(null, (Object[])args.stream().toArray(Object[]::new));
        }
        catch (NoSuchMethodException nsme) {
            Class[] paramTypes = (Class[])args.stream().map(a -> {
                Class<?> k = a.getClass();
                try {
                    Object type = k.getField("TYPE").get(null);
                    if (type instanceof Class) {
                        return (Class)type;
                    }
                    return k;
                }
                catch (IllegalAccessException | NoSuchFieldException nsfe) {
                    return k;
                }
            }).toArray(Class[]::new);
            return klass.getMethod(methodName, paramTypes).invoke(null, (Object[])args.stream().toArray(Object[]::new));
        }
    }

    public Object createCallback(String interfaceName, final Closure closure) throws Exception {
        final Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return Proxy.newProxyInstance(this.classloader, new Class[]{Class.forName(interfaceName, true, this.classloader)}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                if (args.length == closure.getMaximumNumberOfParameters()) {
                    return closure.call(args);
                }
                Class<?> declaringClass = m.getDeclaringClass();
                return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(m, declaringClass).bindTo(proxy).invokeWithArguments(args);
            }
        });
    }

    public Object newInstance(String className, Object ... args) throws Exception {
        Class<?> klass = Class.forName(className, true, this.classloader);
        return klass.getConstructor((Class[])Arrays.stream(args).map(a -> a.getClass()).toArray(Class[]::new)).newInstance(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newBookKeeper(String zookeeper) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Class<?> clientConfigurationClass = Class.forName("org.apache.bookkeeper.conf.ClientConfiguration", true, this.classloader);
            Object clientConfiguration = this.newInstance("org.apache.bookkeeper.conf.ClientConfiguration", new Object[0]);
            clientConfigurationClass.getMethod("setZkServers", String.class).invoke(clientConfiguration, zookeeper);
            clientConfigurationClass.getMethod("setReadTimeout", Integer.TYPE).invoke(clientConfiguration, 15);
            clientConfigurationClass.getMethod("setZkTimeout", Integer.TYPE).invoke(clientConfiguration, 30000);
            Class<?> klass = Class.forName("org.apache.bookkeeper.client.BookKeeper", true, this.classloader);
            Object obj = klass.getConstructor(clientConfigurationClass).newInstance(clientConfiguration);
            return obj;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public Object digestType(String type) throws Exception {
        String className = "org.apache.bookkeeper.client.BookKeeper$DigestType";
        for (Object o : this.classloader.loadClass(className).getEnumConstants()) {
            if (!o.toString().equals(type)) continue;
            return o;
        }
        throw new ClassNotFoundException("No such digest type " + type);
    }

    @Override
    public void close() throws Exception {
        if (this.classloader instanceof Closeable) {
            delayedCloseExecutor.schedule(() -> {
                try {
                    ((Closeable)((Object)this.classloader)).close();
                }
                catch (Exception e) {
                    log.error("Failed to close classloader", (Throwable)e);
                }
            }, 5L, TimeUnit.SECONDS);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void extractTarGz(File tarGz, File output) throws Exception {
        File tarFile = new File(output, tarGz.getName().replace(".gz", ""));
        tarFile.delete();
        MavenClassLoader.deCompressGZipFile(tarGz, tarFile);
        MavenClassLoader.unTar(tarFile, output);
    }

    private static File deCompressGZipFile(File gZippedFile, File tarFile) throws IOException {
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(gZippedFile));
             FileOutputStream fos = new FileOutputStream(tarFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gZIPInputStream.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        return tarFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void unTar(File inputFile, File outputDir) throws Exception {
        try (FileInputStream fis = new FileInputStream(inputFile);
             TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)fis);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                FileOutputStream outputFileStream;
                block37: {
                    File outputFile = new File(outputDir, entry.getName());
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    if (entry.isDirectory()) {
                        if (outputFile.exists()) {
                            FileUtils.deleteDirectory((File)outputFile);
                        }
                        if (outputFile.mkdirs()) continue;
                        throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                    }
                    outputFileStream = new FileOutputStream(outputFile);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                        if (outputFileStream == null) continue;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputFileStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputFileStream).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)outputFileStream).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)outputFileStream).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)outputFileStream).close();
            }
            return;
        }
    }
}

