/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.integration.utils;

import com.github.dockerjava.api.DockerClient;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.bookkeeper.tests.integration.utils.DockerUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperClusterUtils {
    public static final String CURRENT_VERSION = System.getProperty("currentVersion");
    public static final List<String> OLD_CLIENT_VERSIONS = Arrays.asList("4.8.2", "4.9.2", "4.10.0", "4.11.1", "4.12.1", "4.13.0", "4.14.4");
    private static final List<String> OLD_CLIENT_VERSIONS_WITH_CURRENT_LEDGER_METADATA_FORMAT = Arrays.asList("4.9.2", "4.10.0", "4.11.1", "4.12.1", "4.13.0", "4.14.4");
    private static final List<String> OLD_CLIENT_VERSIONS_WITH_OLD_BK_BIN_NAME = Arrays.asList("4.9.2", "4.10.0", "4.11.1", "4.12.1", "4.13.0", "4.14.3", "4.3-yahoo");
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperClusterUtils.class);

    public static boolean hasVersionLatestMetadataFormat(String version) {
        return OLD_CLIENT_VERSIONS_WITH_CURRENT_LEDGER_METADATA_FORMAT.contains(version);
    }

    public static String zookeeperConnectString(DockerClient docker) {
        return DockerUtils.cubeIdsMatching("zookeeper").stream().map(id -> DockerUtils.getContainerIP(docker, id)).collect(Collectors.joining(":"));
    }

    public static ZooKeeper zookeeperClient(DockerClient docker) throws Exception {
        String connectString = BookKeeperClusterUtils.zookeeperConnectString(docker);
        CompletableFuture future = new CompletableFuture();
        ZooKeeper zk = new ZooKeeper(connectString, 10000, e -> {
            if (e.getState().equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                future.complete(null);
            }
        });
        future.get();
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zookeeperRunning(DockerClient docker, String containerId) {
        boolean bl;
        block6: {
            String ip = DockerUtils.getContainerIP(docker, containerId);
            CompletableFuture future = new CompletableFuture();
            ZooKeeper zk = new ZooKeeper(ip + ":2181", 10000, e -> {
                if (e.getState().equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                    future.complete(null);
                }
            });
            try {
                future.get();
                bl = true;
                if (zk == null) break block6;
            }
            catch (Throwable throwable) {
                if (zk != null) {
                    zk.close();
                }
                throw throwable;
            }
            zk.close();
        }
        return bl;
    }

    public static void legacyMetadataFormat(DockerClient docker) throws Exception {
        try (ZooKeeper zk = BookKeeperClusterUtils.zookeeperClient(docker);){
            if (zk.exists("/ledgers", false) == null) {
                zk.create("/ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (zk.exists("/ledgers/available", false) == null) {
                zk.create("/ledgers/available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean metadataFormatIfNeeded(DockerClient docker, String version) throws Exception {
        try (ZooKeeper zk = BookKeeperClusterUtils.zookeeperClient(docker);){
            if (zk.exists("/ledgers", false) == null) {
                String bookkeeper = "/opt/bookkeeper/" + version + "/bin/" + BookKeeperClusterUtils.computeBinFilenameByVersion(version);
                BookKeeperClusterUtils.runOnAnyBookie(docker, bookkeeper, "shell", "metaformat", "-nonInteractive");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createDlogNamespaceIfNeeded(DockerClient docker, String version, String namespace) throws Exception {
        String zkServers = BookKeeperClusterUtils.zookeeperConnectString(docker);
        String dlogUri = "distributedlog://" + zkServers + namespace;
        try (ZooKeeper zk = BookKeeperClusterUtils.zookeeperClient(docker);){
            if (zk.exists(namespace, false) == null) {
                String dlog = "/opt/bookkeeper/" + version + "/bin/dlog";
                BookKeeperClusterUtils.runOnAnyBookie(docker, dlog, "admin", "bind", "-l", "/ledgers", "-s", zkServers, "-c", dlogUri);
            }
            String string = dlogUri;
            return string;
        }
    }

    public static void formatAllBookies(DockerClient docker, String version) throws Exception {
        String bookkeeper = "/opt/bookkeeper/" + version + "/bin/" + BookKeeperClusterUtils.computeBinFilenameByVersion(version);
        BookKeeperClusterUtils.runOnAllBookies(docker, bookkeeper, "shell", "bookieformat", "-nonInteractive");
    }

    public static void updateBookieConf(DockerClient docker, String containerId, String version, String key, String value) throws Exception {
        String confFile = "/opt/bookkeeper/" + version + "/conf/bk_server.conf";
        String sedProgram = String.format("/[[:blank:]]*%s[[:blank:]]*=/ { h; s!=.*!=%s!; }; ${x;/^$/ { s//%s=%s/;H; }; x}", key, value, key, value);
        DockerUtils.runCommand(docker, containerId, "sed", "-i", "-e", sedProgram, confFile);
    }

    public static void updateAllBookieConf(DockerClient docker, String version, String key, String value) throws Exception {
        for (String b : BookKeeperClusterUtils.allBookies()) {
            BookKeeperClusterUtils.updateBookieConf(docker, b, version, key, value);
        }
    }

    public static boolean runOnAnyBookie(DockerClient docker, String ... cmds) throws Exception {
        Optional bookie = BookKeeperClusterUtils.allBookies().stream().findAny();
        if (bookie.isPresent()) {
            DockerUtils.runCommand(docker, (String)bookie.get(), cmds);
            return true;
        }
        return false;
    }

    public static String getAnyBookie() throws Exception {
        Optional bookie = BookKeeperClusterUtils.allBookies().stream().findAny();
        if (bookie.isPresent()) {
            return (String)bookie.get();
        }
        throw new Exception("No bookie is available");
    }

    public static void runOnAllBookies(DockerClient docker, String ... cmds) throws Exception {
        for (String b : BookKeeperClusterUtils.allBookies()) {
            DockerUtils.runCommand(docker, b, cmds);
        }
    }

    public static Set<String> allBookies() {
        return DockerUtils.cubeIdsMatching("bookkeeper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitBookieState(DockerClient docker, String containerId, int timeout, TimeUnit timeoutUnit, boolean upOrDown) {
        long pollMillis = 1000L;
        String bookieId = DockerUtils.getContainerIP(docker, containerId) + ":3181";
        try (ZooKeeper zk = BookKeeperClusterUtils.zookeeperClient(docker);){
            String path = "/ledgers/available/" + bookieId;
            for (long timeoutMillis = timeoutUnit.toMillis(timeout); timeoutMillis > 0L; timeoutMillis -= pollMillis) {
                if (zk.exists(path, false) != null == upOrDown) {
                    boolean bl = true;
                    return bl;
                }
                Thread.sleep(pollMillis);
            }
        }
        catch (Exception e) {
            LOG.error("Exception checking for bookie state", (Throwable)e);
            return false;
        }
        LOG.warn("Bookie {} didn't go {} after {} seconds", new Object[]{containerId, upOrDown ? "up" : "down", timeoutUnit.toSeconds(timeout)});
        return false;
    }

    public static boolean waitBookieUp(DockerClient docker, String containerId, int timeout, TimeUnit timeoutUnit) {
        return BookKeeperClusterUtils.waitBookieState(docker, containerId, timeout, timeoutUnit, true);
    }

    public static boolean waitBookieDown(DockerClient docker, String containerId, int timeout, TimeUnit timeoutUnit) {
        return BookKeeperClusterUtils.waitBookieState(docker, containerId, timeout, timeoutUnit, false);
    }

    public static boolean startBookieWithVersion(DockerClient docker, String containerId, String version) {
        try {
            DockerUtils.runCommand(docker, containerId, "supervisorctl", "start", "bookkeeper-" + version);
        }
        catch (Exception e) {
            LOG.error("Exception starting bookie", (Throwable)e);
            return false;
        }
        return BookKeeperClusterUtils.waitBookieUp(docker, containerId, 10, TimeUnit.SECONDS);
    }

    private static boolean allTrue(boolean accumulator, boolean result) {
        return accumulator && result;
    }

    public static boolean startAllBookiesWithVersion(DockerClient docker, String version) throws Exception {
        return BookKeeperClusterUtils.allBookies().stream().map(b -> BookKeeperClusterUtils.startBookieWithVersion(docker, b, version)).reduce(true, BookKeeperClusterUtils::allTrue);
    }

    public static boolean stopBookie(DockerClient docker, String containerId) {
        try {
            DockerUtils.runCommand(docker, containerId, "supervisorctl", "stop", "all");
        }
        catch (Exception e) {
            LOG.error("Exception stopping bookie", (Throwable)e);
            return false;
        }
        return BookKeeperClusterUtils.waitBookieDown(docker, containerId, 5, TimeUnit.SECONDS);
    }

    public static boolean stopAllBookies(DockerClient docker) {
        return BookKeeperClusterUtils.allBookies().stream().map(b -> BookKeeperClusterUtils.stopBookie(docker, b)).reduce(true, BookKeeperClusterUtils::allTrue);
    }

    public static boolean waitAllBookieUp(DockerClient docker) {
        return BookKeeperClusterUtils.allBookies().stream().map(b -> BookKeeperClusterUtils.waitBookieUp(docker, b, 10, TimeUnit.SECONDS)).reduce(true, BookKeeperClusterUtils::allTrue);
    }

    private static String computeBinFilenameByVersion(String version) {
        return "bookkeeper";
    }
}

