/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tests.integration.utils;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.jboss.shrinkwrap.resolver.api.Coordinate;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClassLoader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MavenClassLoader.class);
    private final URLClassLoader classloader;

    private MavenClassLoader(URLClassLoader cl) {
        this.classloader = cl;
    }

    public static MavenClassLoader forArtifact(String repo, String mainArtifact) throws Exception {
        return MavenClassLoader.createClassLoader((ConfigurableMavenResolverSystem)Maven.configureResolver().withRemoteRepo("custom", repo, "default"), mainArtifact);
    }

    public static MavenClassLoader forArtifact(String mainArtifact) throws Exception {
        return MavenClassLoader.createClassLoader(Maven.configureResolver(), mainArtifact);
    }

    private static MavenClassLoader createClassLoader(ConfigurableMavenResolverSystem resolver, String mainArtifact) throws Exception {
        Optional<String> slf4jVersion = Arrays.stream(((MavenFormatStage)((MavenStrategyStage)resolver.resolve(mainArtifact)).withTransitivity()).asResolvedArtifact()).filter(a -> a.getCoordinate().getGroupId().equals("org.slf4j") && a.getCoordinate().getArtifactId().equals("slf4j-log4j12")).map(a -> a.getCoordinate().getVersion()).findFirst();
        ArrayList deps = Lists.newArrayList((Object[])new MavenDependency[]{MavenDependencies.createDependency((String)mainArtifact, (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[]{MavenDependencies.createExclusion((String)"org.slf4j:slf4j-log4j12"), MavenDependencies.createExclusion((String)"log4j:log4j")})});
        if (slf4jVersion.isPresent()) {
            deps.add(MavenDependencies.createDependency((String)("org.slf4j:slf4j-simple:" + slf4jVersion.get()), (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]));
        }
        final File[] files = ((MavenFormatStage)((MavenStrategyStage)((PomlessResolveStage)resolver.addDependencies((Coordinate[])deps.toArray(new MavenDependency[0]))).resolve()).withTransitivity()).asFile();
        URLClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader((URL[])Arrays.stream(files).map(f -> {
                    try {
                        return f.toURI().toURL();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }).toArray(URL[]::new), ClassLoader.getSystemClassLoader());
            }
        });
        return new MavenClassLoader(cl);
    }

    public static MavenClassLoader forBookKeeperVersion(String version) throws Exception {
        return MavenClassLoader.forArtifact("org.apache.bookkeeper:bookkeeper-server:" + version);
    }

    public Object getClass(String className) throws Exception {
        return Class.forName(className, true, this.classloader);
    }

    public Object callStaticMethod(String className, String methodName, ArrayList<?> args) throws Exception {
        Class<?> klass = Class.forName(className, true, this.classloader);
        try {
            Class[] paramTypes = (Class[])args.stream().map(a -> a.getClass()).toArray(Class[]::new);
            return klass.getMethod(methodName, paramTypes).invoke(null, (Object[])args.stream().toArray(Object[]::new));
        }
        catch (NoSuchMethodException nsme) {
            Class[] paramTypes = (Class[])args.stream().map(a -> {
                Class<?> k = a.getClass();
                try {
                    Object type = k.getField("TYPE").get(null);
                    if (type instanceof Class) {
                        return (Class)type;
                    }
                    return k;
                }
                catch (IllegalAccessException | NoSuchFieldException nsfe) {
                    return k;
                }
            }).toArray(Class[]::new);
            return klass.getMethod(methodName, paramTypes).invoke(null, (Object[])args.stream().toArray(Object[]::new));
        }
    }

    public Object createCallback(String interfaceName, final Closure closure) throws Exception {
        final Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return Proxy.newProxyInstance(this.classloader, new Class[]{Class.forName(interfaceName, true, this.classloader)}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                if (args.length == closure.getMaximumNumberOfParameters()) {
                    return closure.call(args);
                }
                Class<?> declaringClass = m.getDeclaringClass();
                return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(m, declaringClass).bindTo(proxy).invokeWithArguments(args);
            }
        });
    }

    public Object newInstance(String className, Object ... args) throws Exception {
        Class<?> klass = Class.forName(className, true, this.classloader);
        return klass.getConstructor((Class[])Arrays.stream(args).map(a -> a.getClass()).toArray(Class[]::new)).newInstance(args);
    }

    public Object newBookKeeper(String zookeeper) throws Exception {
        return this.newInstance("org.apache.bookkeeper.client.BookKeeper", zookeeper);
    }

    public Object digestType(String type) throws Exception {
        String className = "org.apache.bookkeeper.client.BookKeeper$DigestType";
        for (Object o : this.classloader.loadClass(className).getEnumConstants()) {
            if (!o.toString().equals(type)) continue;
            return o;
        }
        throw new ClassNotFoundException("No such digest type " + type);
    }

    @Override
    public void close() throws Exception {
        this.classloader.close();
    }
}

