/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.apache.pulsar.zookeeper.ZookeeperServerTest;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZookeeperClientFactoryImplTest {
    private ZookeeperServerTest localZkS;
    private ZooKeeper localZkc;
    private final long ZOOKEEPER_SESSION_TIMEOUT_MILLIS = 5000L;

    @BeforeMethod
    void setup() throws Exception {
        this.localZkS = new ZookeeperServerTest(0);
        this.localZkS.start();
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
        this.localZkS.close();
    }

    @Test
    public void testZKCreationRW() throws Exception {
        ZookeeperClientFactoryImpl zkf = new ZookeeperClientFactoryImpl();
        CompletableFuture zkFuture = zkf.create("127.0.0.1:" + this.localZkS.getZookeeperPort(), ZooKeeperClientFactory.SessionType.ReadWrite, 5000);
        this.localZkc = (ZooKeeper)zkFuture.get(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.localZkc.getState().isConnected());
        Assert.assertNotEquals((Object)this.localZkc.getState(), (Object)ZooKeeper.States.CONNECTEDREADONLY);
        this.localZkc.close();
    }

    @Test
    public void testZKCreationRO() throws Exception {
        ZookeeperClientFactoryImpl zkf = new ZookeeperClientFactoryImpl();
        CompletableFuture zkFuture = zkf.create("127.0.0.1:" + this.localZkS.getZookeeperPort(), ZooKeeperClientFactory.SessionType.AllowReadOnly, 5000);
        this.localZkc = (ZooKeeper)zkFuture.get(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.localZkc.getState().isConnected());
        this.localZkc.close();
    }

    @Test
    public void testZKCreationFailure() throws Exception {
        ZookeeperClientFactoryImpl zkf = new ZookeeperClientFactoryImpl();
        CompletableFuture zkFuture = zkf.create("invalid", ZooKeeperClientFactory.SessionType.ReadWrite, 5000);
        try {
            zkFuture.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

