/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperServerTest
implements Closeable {
    private final File zkTmpDir = File.createTempFile("zookeeper", "test");
    private ZooKeeperServer zks;
    private NIOServerCnxnFactory serverFactory;
    private int zkPort;
    private String hostPort;
    private static final Logger log = LoggerFactory.getLogger(ZookeeperServerTest.class);

    public ZookeeperServerTest(int zkPort) throws IOException {
        log.info("**** Start GZK on {} ****", (Object)this.zkTmpDir);
        if (!this.zkTmpDir.delete() || !this.zkTmpDir.mkdir()) {
            throw new IOException("Couldn't create zk directory " + this.zkTmpDir);
        }
    }

    public void start() throws IOException {
        try {
            System.setProperty("zookeeper.4lw.commands.whitelist", "*");
            System.setProperty("zookeeper.admin.enableServer", "false");
            this.zks = new ZooKeeperServer(this.zkTmpDir, this.zkTmpDir, 3000);
            this.zks.setMaxSessionTimeout(20000);
            this.serverFactory = new NIOServerCnxnFactory();
            this.serverFactory.configure(new InetSocketAddress(this.zkPort), 1000);
            this.serverFactory.startup(this.zks);
        }
        catch (Exception e) {
            log.error("Exception while instantiating ZooKeeper", (Throwable)e);
        }
        this.zkPort = this.serverFactory.getLocalPort();
        this.hostPort = "127.0.0.1:" + this.zkPort;
        LocalBookkeeperEnsemble.waitForServerUp((String)this.hostPort, (long)30000L);
        log.info("ZooKeeper started at {}", (Object)this.hostPort);
    }

    public void stop() throws IOException {
        this.zks.shutdown();
        this.serverFactory.shutdown();
        log.info("Stoppend ZK server at {}", (Object)this.hostPort);
    }

    @Override
    public void close() throws IOException {
        this.zks.shutdown();
        this.serverFactory.shutdown();
        this.zkTmpDir.delete();
    }

    public int getZookeeperPort() {
        return this.serverFactory.getLocalPort();
    }

    public String getHostPort() {
        return this.hostPort;
    }
}

