/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.zookeeper.Deserializers;
import org.apache.pulsar.zookeeper.GlobalZooKeeperCache;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZookeeperCacheTest {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperCacheTest.class);
    private MockZooKeeper zkClient;
    private OrderedScheduler executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeMethod(alwaysRun=true)
    void setup() throws Exception {
        this.zkClient = MockZooKeeper.newInstance((ExecutorService)MoreExecutors.newDirectExecutorService());
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
        this.zkClient.shutdown();
    }

    @BeforeClass(alwaysRun=true)
    void classSetup() throws Exception {
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("ZookeeperCacheTest").build();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    void classTeardown() throws Exception {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test(timeOut=10000L)
    public void testSimpleCache() throws Exception {
        LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)this.zkClient, 30, (OrderedExecutor)this.executor);
        ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

            public String deserialize(String key, byte[] content) throws Exception {
                return new String(content);
            }
        };
        String value = "test";
        this.zkClient.create("/my_test", value.getBytes(), null, null);
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)value);
        Assert.assertEquals((String)((String)zkCache.getDataIfPresent("/my_test")), (String)value);
        String newValue = "test2";
        this.zkClient.setData("/my_test", newValue.getBytes(), -1);
        Thread.sleep(100L);
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        this.zkClient.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/other"));
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        try {
            zkCache.get("/other");
            Assert.fail((String)"shuld have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeOut=10000L)
    public void testChildrenCache() throws Exception {
        this.zkClient.create("/test", new byte[0], null, null);
        LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)this.zkClient, 30, (OrderedExecutor)this.executor);
        ZooKeeperChildrenCache cache = new ZooKeeperChildrenCache((ZooKeeperCache)zkCacheService, "/test");
        AtomicInteger notificationCount = new AtomicInteger(0);
        ZooKeeperCacheListener counter = (path, data, stat) -> notificationCount.incrementAndGet();
        cache.registerListener(counter);
        cache.registerListener(counter);
        cache.unregisterListener(counter);
        Assert.assertEquals((int)notificationCount.get(), (int)0);
        Assert.assertEquals((Set)cache.get(), (Set)Sets.newTreeSet());
        this.zkClient.create("/test/z1", new byte[0], null, null);
        this.zkClient.create("/test/z2", new byte[0], null, null);
        while (notificationCount.get() < 2) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((Set)cache.get(), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1", "z2"})));
        Assert.assertEquals((Set)cache.get("/test"), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1", "z2"})));
        Assert.assertEquals((int)notificationCount.get(), (int)2);
        this.zkClient.delete("/test/z2", -1);
        while (notificationCount.get() < 3) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((Set)cache.get(), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1"})));
        Assert.assertEquals((Set)cache.get(), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1"})));
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.zkClient.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/test"));
        try {
            cache.get();
            Assert.fail((String)"shuld have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)notificationCount.get(), (int)3);
    }

    @Test(timeOut=10000L)
    public void testChildrenCacheZnodeCreatedAfterCache() throws Exception {
        LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)this.zkClient, 30, (OrderedExecutor)this.executor);
        ZooKeeperChildrenCache cache = new ZooKeeperChildrenCache((ZooKeeperCache)zkCacheService, "/test");
        AtomicInteger notificationCount = new AtomicInteger(0);
        ZooKeeperCacheListener counter = (path, data, stat) -> notificationCount.incrementAndGet();
        cache.registerListener(counter);
        cache.registerListener(counter);
        cache.unregisterListener(counter);
        Assert.assertEquals((int)notificationCount.get(), (int)0);
        Assert.assertEquals((Set)cache.get(), Collections.emptySet());
        this.zkClient.create("/test", new byte[0], null, null);
        this.zkClient.create("/test/z1", new byte[0], null, null);
        while (notificationCount.get() < 1) {
            Thread.sleep(1L);
        }
        int recvNotifications = notificationCount.get();
        Assert.assertEquals((Set)cache.get(), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1"})));
        Assert.assertEquals((Set)cache.get("/test"), new TreeSet(Lists.newArrayList((Object[])new String[]{"z1"})));
        Assert.assertTrue((recvNotifications == 1 || recvNotifications == 2 ? 1 : 0) != 0);
        this.zkClient.delete("/test/z1", -1);
        while (notificationCount.get() < recvNotifications + 1) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)cache.get().isEmpty());
        Assert.assertTrue((boolean)cache.get().isEmpty());
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.zkClient.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/test"));
        try {
            cache.get();
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeOut=10000L)
    public void testExistsCache() throws Exception {
        this.zkClient.create("/test", new byte[0], null, null);
        Thread.sleep(20L);
        LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)this.zkClient, 30, (OrderedExecutor)this.executor);
        boolean exists = zkCacheService.exists("/test");
        Assert.assertTrue((boolean)exists, (String)"/test should exists in the cache");
        this.zkClient.delete("/test", -1);
        Thread.sleep(20L);
        boolean shouldNotExist = zkCacheService.exists("/test");
        Assert.assertFalse((boolean)shouldNotExist, (String)"/test should not exist in the cache");
    }

    @Test(timeOut=10000L)
    public void testInvalidateCache() throws Exception {
        this.zkClient.create("/test", new byte[0], null, null);
        this.zkClient.create("/test/c1", new byte[0], null, null);
        this.zkClient.create("/test/c2", new byte[0], null, null);
        Thread.sleep(20L);
        LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)this.zkClient, 30, (OrderedExecutor)this.executor);
        boolean exists = zkCacheService.exists("/test");
        Assert.assertTrue((boolean)exists, (String)"/test should exists in the cache");
        AssertJUnit.assertNull((Object)zkCacheService.getChildrenIfPresent("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getChildren("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getChildrenIfPresent("/test"));
        zkCacheService.invalidateAllChildren();
        AssertJUnit.assertNull((Object)zkCacheService.getChildrenIfPresent("/test"));
        AssertJUnit.assertNull((Object)zkCacheService.getDataIfPresent("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getData("/test", Deserializers.STRING_DESERIALIZER));
        AssertJUnit.assertNotNull((Object)zkCacheService.getDataIfPresent("/test"));
        zkCacheService.invalidateData("/test");
        AssertJUnit.assertNull((Object)zkCacheService.getDataIfPresent("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getChildren("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getData("/test", Deserializers.STRING_DESERIALIZER));
        zkCacheService.invalidateAll();
        AssertJUnit.assertNull((Object)zkCacheService.getChildrenIfPresent("/test"));
        AssertJUnit.assertNull((Object)zkCacheService.getDataIfPresent("/test"));
        AssertJUnit.assertNotNull((Object)zkCacheService.getChildren("/test"));
        zkCacheService.invalidateRoot("/test");
        AssertJUnit.assertNull((Object)zkCacheService.getChildrenIfPresent("/test"));
    }

    @Test(timeOut=10000L)
    public void testGlobalZooKeeperCache() throws Exception {
        final MockZooKeeper zkc = MockZooKeeper.newInstance();
        ZooKeeperClientFactory zkClientfactory = new ZooKeeperClientFactory(){

            public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
                return CompletableFuture.completedFuture(zkc);
            }
        };
        GlobalZooKeeperCache zkCacheService = new GlobalZooKeeperCache(zkClientfactory, -1, 30, "", (OrderedExecutor)this.executor, this.scheduledExecutor, 300);
        zkCacheService.start();
        this.zkClient = (MockZooKeeper)zkCacheService.getZooKeeper();
        ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

            public String deserialize(String key, byte[] content) throws Exception {
                return new String(content);
            }
        };
        AtomicInteger notificationCount = new AtomicInteger(0);
        ZooKeeperCacheListener counter = (path, data, stat) -> notificationCount.incrementAndGet();
        zkCache.registerListener(counter);
        zkCache.registerListener(counter);
        zkCache.unregisterListener(counter);
        String value = "test";
        this.zkClient.create("/my_test", value.getBytes(), null, null);
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)value);
        String newValue = "test2";
        Assert.assertEquals((int)notificationCount.get(), (int)0);
        this.zkClient.setData("/my_test", newValue.getBytes(), -1);
        this.zkClient.create("/my_test2", value.getBytes(), null, null);
        while (notificationCount.get() < 1) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        Assert.assertEquals((String)((String)zkCache.get("/my_test2").get()), (String)value);
        Assert.assertEquals((int)notificationCount.get(), (int)1);
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        Assert.assertEquals((String)((String)zkCache.get("/my_test2").get()), (String)value);
        this.zkClient.create("/other", newValue.getBytes(), null, null);
        this.zkClient.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/other"));
        Assert.assertEquals((String)((String)zkCache.get("/my_test").get()), (String)newValue);
        Assert.assertEquals((String)((String)zkCache.get("/my_test2").get()), (String)value);
        try {
            zkCache.get("/other");
            Assert.fail((String)"shuld have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zkClient.delete("/my_test2", -1);
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null));
        Assert.assertEquals((String)((String)zkCache.get("/other").get()), (String)newValue);
        Assert.assertFalse((boolean)zkCache.get("/my_test2").isPresent());
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.zkClient.create("/other2", newValue.getBytes(), null, null);
        zkCacheService.process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null));
        Assert.assertEquals((String)((String)zkCache.get("/other2").get()), (String)newValue);
        zkCacheService.close();
        Assert.assertEquals((int)notificationCount.get(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=2000L)
    public void testZkCallbackThreadStuck() throws Exception {
        OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
            try {
                ExecutorService zkExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("mockZk"));
                try {
                    MockZooKeeper zkClient = MockZooKeeper.newInstance((ExecutorService)zkExecutor, (int)100);
                    LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)zkClient, 30, (OrderedExecutor)executor);
                    ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

                        public String deserialize(String key, byte[] content) throws Exception {
                            return new String(content);
                        }
                    };
                    String value = "test";
                    String key = "/" + UUID.randomUUID().toString().substring(0, 8);
                    String key1 = "/" + UUID.randomUUID().toString().substring(0, 8);
                    String key2 = "/" + UUID.randomUUID().toString().substring(0, 8);
                    zkClient.create(key, value.getBytes(), null, null);
                    zkClient.create(key1, value.getBytes(), null, null);
                    zkClient.create(key2, value.getBytes(), null, null);
                    CountDownLatch latch = new CountDownLatch(1);
                    zkCache.getAsync(key).thenAccept(arg_0 -> ZookeeperCacheTest.lambda$testZkCallbackThreadStuck$7((ZooKeeperDataCache)zkCache, key1, key2, latch, arg_0));
                    latch.await();
                }
                finally {
                    if (Collections.singletonList(zkExecutor).get(0) != null) {
                        zkExecutor.shutdownNow();
                    }
                }
            }
            finally {
                if (Collections.singletonList(scheduledExecutor).get(0) != null) {
                    scheduledExecutor.shutdownNow();
                }
            }
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void testInvalidateCacheOnFailure() throws Exception {
        ExecutorService zkExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("mockZk"));
        try {
            MockZooKeeper zkClient = MockZooKeeper.newInstance((ExecutorService)zkExecutor, (int)100);
            LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)zkClient, 30, (OrderedExecutor)this.executor);
            final AtomicInteger count = new AtomicInteger(0);
            ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

                public String deserialize(String key, byte[] content) throws Exception {
                    if (count.getAndIncrement() == 0) {
                        throw new NullPointerException("data is null");
                    }
                    return new String(content);
                }
            };
            String value = "test";
            String key1 = "/zkDesrializationExceptionTest";
            String key2 = "/zkSessionExceptionTest";
            zkClient.create(key1, value.getBytes(), null, null);
            zkClient.create(key2, value.getBytes(), null, null);
            try {
                zkCache.getAsync(key1).get();
                Assert.fail((String)"it should have failed with NPE");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
            }
            Thread.sleep(1000L);
            Assert.assertEquals((String)((String)((Optional)zkCache.getAsync(key1).get()).get()), (String)value);
            ZooKeeper zkSession = (ZooKeeper)zkCacheService.zkSession.get();
            zkCacheService.zkSession.set(null);
            try {
                zkCache.getAsync(key2).get();
                Assert.fail((String)"it should have failed with NPE");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
            }
            zkCacheService.zkSession.set(zkSession);
            Thread.sleep(1000L);
            Assert.assertEquals((String)((String)((Optional)zkCache.getAsync(key1).get()).get()), (String)value);
        }
        finally {
            if (Collections.singletonList(zkExecutor).get(0) != null) {
                zkExecutor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimedOutZKCacheRequestInvalidates() throws Exception {
        OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
            try {
                ExecutorService zkExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("mockZk"));
                try {
                    MockZooKeeper zkSession = (MockZooKeeper)Mockito.spy((Object)MockZooKeeper.newInstance((ExecutorService)MoreExecutors.newDirectExecutorService()));
                    String path = "test";
                    ((MockZooKeeper)Mockito.doNothing().when((Object)zkSession)).getData(Mockito.anyString(), (Watcher)Mockito.any(Watcher.class), (AsyncCallback.DataCallback)Mockito.any(AsyncCallback.DataCallback.class), Mockito.any());
                    this.zkClient.create("/test", new byte[0], null, null);
                    LocalZooKeeperCache zkCacheService = new LocalZooKeeperCache((ZooKeeper)zkSession, 1, (OrderedExecutor)executor);
                    ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

                        public String deserialize(String key, byte[] content) throws Exception {
                            return new String(content);
                        }
                    };
                    try {
                        zkCache.get(path);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ZookeeperCacheTest.retryStrategically(arg_0 -> ZookeeperCacheTest.lambda$testTimedOutZKCacheRequestInvalidates$8((ZooKeeperCache)zkCacheService, path, arg_0), 5, 1000L);
                    AssertJUnit.assertNull((Object)zkCacheService.dataCache.getIfPresent((Object)path));
                }
                finally {
                    if (Collections.singletonList(zkExecutor).get(0) != null) {
                        zkExecutor.shutdownNow();
                    }
                }
            }
            finally {
                if (Collections.singletonList(scheduledExecutor).get(0) != null) {
                    scheduledExecutor.shutdownNow();
                }
            }
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZKRefreshExpiredEntry() throws Exception {
        int cacheExpiryTimeSec = 1;
        OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2);
            try {
                ExecutorService zkExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("mockZk"));
                try {
                    String path = "/test";
                    String val1 = "test-1";
                    String val2 = "test-2";
                    this.zkClient.create(path, val1.getBytes(), null, null);
                    ZooKeeperCacheTest zkCacheService = new ZooKeeperCacheTest("test", (ZooKeeper)this.zkClient, 30, (OrderedExecutor)executor, cacheExpiryTimeSec);
                    ZooKeeperDataCache<String> zkCache = new ZooKeeperDataCache<String>((ZooKeeperCache)zkCacheService){

                        public String deserialize(String key, byte[] content) throws Exception {
                            return new String(content);
                        }
                    };
                    Assert.assertEquals((String)((String)zkCache.get(path).get()), (String)val1);
                    this.zkClient.setData(path, val2.getBytes(), -1);
                    ZookeeperCacheTest.retryStrategically(arg_0 -> ZookeeperCacheTest.lambda$testZKRefreshExpiredEntry$9((ZooKeeperDataCache)zkCache, path, val2, arg_0), 5, 1000L);
                    Assert.assertEquals((String)((String)zkCache.get(path).get()), (String)val2);
                }
                finally {
                    if (Collections.singletonList(zkExecutor).get(0) != null) {
                        zkExecutor.shutdownNow();
                    }
                }
            }
            finally {
                if (Collections.singletonList(scheduledExecutor).get(0) != null) {
                    scheduledExecutor.shutdownNow();
                }
            }
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    private static void retryStrategically(Predicate<Void> predicate, int retryCount, long intSleepTimeInMillis) throws Exception {
        for (int i = 0; i < retryCount && !predicate.test(null) && i != retryCount - 1; ++i) {
            Thread.sleep(intSleepTimeInMillis + intSleepTimeInMillis * (long)i);
        }
    }

    private static /* synthetic */ boolean lambda$testZKRefreshExpiredEntry$9(ZooKeeperDataCache zkCache, String path, String val2, Void test) {
        try {
            return ((String)zkCache.get(path).get()).equalsIgnoreCase(val2);
        }
        catch (Exception e) {
            log.warn("Failed to get date for path {}", (Object)path);
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$testTimedOutZKCacheRequestInvalidates$8(ZooKeeperCache zkCacheService, String path, Void test) {
        return zkCacheService.dataCache.getIfPresent((Object)path) == null;
    }

    private static /* synthetic */ void lambda$testZkCallbackThreadStuck$7(ZooKeeperDataCache zkCache, String key1, String key2, CountDownLatch latch, Optional val) {
        try {
            zkCache.get(key1);
        }
        catch (Exception e) {
            Assert.fail((String)("failed to get " + key2), (Throwable)e);
        }
        latch.countDown();
    }

    static class ZooKeeperCacheTest
    extends ZooKeeperCache {
        public ZooKeeperCacheTest(String cacheName, ZooKeeper zkSession, int zkOperationTimeoutSeconds, OrderedExecutor executor, int cacheExpirySeconds) {
            super(cacheName, zkSession, zkOperationTimeoutSeconds, executor, cacheExpirySeconds);
        }
    }
}

