/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.inferred.freebuilder.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkIsolatedBookieEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy
implements ZooKeeperCache.Deserializer<BookiesRackConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(ZkIsolatedBookieEnsemblePlacementPolicy.class);
    public static final String ISOLATION_BOOKIE_GROUPS = "isolationBookieGroups";
    public static final String SECONDARY_ISOLATION_BOOKIE_GROUPS = "secondaryIsolationBookieGroups";
    private ZooKeeperCache bookieMappingCache = null;
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();
    private ImmutablePair<Set<String>, Set<String>> defaultIsolationGroups;

    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        String secondaryIsolationGroupsString;
        String isolationGroupsString;
        HashSet<String> primaryIsolationGroups = new HashSet<String>();
        HashSet<String> secondaryIsolationGroups = new HashSet<String>();
        if (conf.getProperty(ISOLATION_BOOKIE_GROUPS) != null && !(isolationGroupsString = ZkIsolatedBookieEnsemblePlacementPolicy.castToString(conf.getProperty(ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            for (String isolationGroup : isolationGroupsString.split(",")) {
                primaryIsolationGroups.add(isolationGroup);
            }
            this.bookieMappingCache = this.getAndSetZkCache((Configuration)conf);
        }
        if (conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS) != null && !(secondaryIsolationGroupsString = ZkIsolatedBookieEnsemblePlacementPolicy.castToString(conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            for (String isolationGroup : secondaryIsolationGroupsString.split(",")) {
                secondaryIsolationGroups.add(isolationGroup);
            }
        }
        this.defaultIsolationGroups = ImmutablePair.of(primaryIsolationGroups, secondaryIsolationGroups);
        return super.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
    }

    private static String castToString(Object obj) {
        if (null == obj) {
            return "";
        }
        if (obj instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object o : (List)obj) {
                result.add((String)o);
            }
            return String.join((CharSequence)",", result);
        }
        return obj.toString();
    }

    private ZooKeeperCache getAndSetZkCache(Configuration conf) {
        ZooKeeperCache zkCache = null;
        if (conf.getProperty("zk_cache_instance") != null) {
            zkCache = (ZooKeeperCache)conf.getProperty("zk_cache_instance");
        } else if (conf instanceof ClientConfiguration) {
            int zkTimeout = ((ClientConfiguration)conf).getZkTimeout();
            String zkServers = ((ClientConfiguration)conf).getZkServers();
            try {
                ZooKeeperClient zkClient = ZooKeeperClient.newBuilder().connectString(zkServers).sessionTimeoutMs(zkTimeout).build();
                zkCache = new ZooKeeperCache("bookies-isolation", (ZooKeeper)zkClient, (int)TimeUnit.MILLISECONDS.toSeconds(zkTimeout)){};
                conf.addProperty("zk_cache_instance", (Object)zkCache);
            }
            catch (Exception e) {
                LOG.error("Error creating zookeeper client", (Throwable)e);
            }
        } else {
            LOG.error("No zk configurations available");
        }
        return zkCache;
    }

    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        HashMap isolationGroup = new HashMap();
        Set<BookieId> blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, (Pair<Set<String>, Set<String>>)this.defaultIsolationGroups);
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
    }

    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        Set<BookieId> blacklistedBookies;
        Optional<EnsemblePlacementPolicyConfig> ensemblePlacementPolicyConfig = ZkIsolatedBookieEnsemblePlacementPolicy.getEnsemblePlacementPolicyConfig(customMetadata);
        if (ensemblePlacementPolicyConfig.isPresent()) {
            EnsemblePlacementPolicyConfig config = ensemblePlacementPolicyConfig.get();
            Pair<Set<String>, Set<String>> groups = ZkIsolatedBookieEnsemblePlacementPolicy.getIsolationGroup(config);
            blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, groups);
        } else {
            blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, (Pair<Set<String>, Set<String>>)this.defaultIsolationGroups);
        }
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
    }

    private static Optional<EnsemblePlacementPolicyConfig> getEnsemblePlacementPolicyConfig(Map<String, byte[]> customMetadata) {
        byte[] ensemblePlacementPolicyConfigData = customMetadata.get("EnsemblePlacementPolicyConfig");
        if (ensemblePlacementPolicyConfigData != null) {
            try {
                return Optional.ofNullable(EnsemblePlacementPolicyConfig.decode((byte[])ensemblePlacementPolicyConfigData));
            }
            catch (EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException e) {
                LOG.error("Failed to parse the ensemble placement policy config from the custom metadata", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Pair<Set<String>, Set<String>> getIsolationGroup(EnsemblePlacementPolicyConfig ensemblePlacementPolicyConfig) {
        MutablePair pair = new MutablePair();
        String className = ZkIsolatedBookieEnsemblePlacementPolicy.class.getName();
        if (ensemblePlacementPolicyConfig.getPolicyClass().getName().equals(className)) {
            Map properties = ensemblePlacementPolicyConfig.getProperties();
            String primaryIsolationGroupString = ZkIsolatedBookieEnsemblePlacementPolicy.castToString(properties.getOrDefault(ISOLATION_BOOKIE_GROUPS, ""));
            String secondaryIsolationGroupString = ZkIsolatedBookieEnsemblePlacementPolicy.castToString(properties.getOrDefault(SECONDARY_ISOLATION_BOOKIE_GROUPS, ""));
            if (!primaryIsolationGroupString.isEmpty()) {
                pair.setLeft((Object)Sets.newHashSet((Object[])primaryIsolationGroupString.split(",")));
            }
            if (!secondaryIsolationGroupString.isEmpty()) {
                pair.setRight((Object)Sets.newHashSet((Object[])secondaryIsolationGroupString.split(",")));
            }
        }
        return pair;
    }

    private Set<BookieId> getBlacklistedBookiesWithIsolationGroups(int ensembleSize, Pair<Set<String>, Set<String>> isolationGroups) {
        HashSet<BookieId> blacklistedBookies;
        block12: {
            blacklistedBookies = new HashSet<BookieId>();
            try {
                Map bookieGroup;
                if (this.bookieMappingCache == null) break block12;
                BookiesRackConfiguration allGroupsBookieMapping = this.bookieMappingCache.getData("/bookies", this).orElseThrow(() -> new KeeperException.NoNodeException("/bookies"));
                Set allBookies = allGroupsBookieMapping.keySet();
                int totalAvailableBookiesInPrimaryGroup = 0;
                Set primaryIsolationGroup = Collections.emptySet();
                Set secondaryIsolationGroup = Collections.emptySet();
                if (isolationGroups != null) {
                    primaryIsolationGroup = (Set)isolationGroups.getLeft();
                    secondaryIsolationGroup = (Set)isolationGroups.getRight();
                }
                for (String group : allBookies) {
                    Set bookiesInGroup = ((Map)allGroupsBookieMapping.get((Object)group)).keySet();
                    if (!primaryIsolationGroup.contains(group)) {
                        for (String bookieAddress : bookiesInGroup) {
                            blacklistedBookies.add(BookieId.parse((String)bookieAddress));
                        }
                        continue;
                    }
                    for (String groupBookie : bookiesInGroup) {
                        totalAvailableBookiesInPrimaryGroup += this.knownBookies.containsKey(BookieId.parse((String)groupBookie)) ? 1 : 0;
                    }
                }
                for (String group : primaryIsolationGroup) {
                    bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                    if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                    for (String bookieAddress : bookieGroup.keySet()) {
                        blacklistedBookies.remove(BookieId.parse((String)bookieAddress));
                    }
                }
                if (totalAvailableBookiesInPrimaryGroup < ensembleSize) {
                    LOG.info("Not found enough available-bookies from primary isolation group [{}] , checking secondary group [{}]", (Object)primaryIsolationGroup, (Object)secondaryIsolationGroup);
                    for (String group : secondaryIsolationGroup) {
                        bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                        if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                        for (String bookieAddress : bookieGroup.keySet()) {
                            blacklistedBookies.remove(BookieId.parse((String)bookieAddress));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error getting bookie isolation info from zk: {}", (Object)e.getMessage());
            }
        }
        return blacklistedBookies;
    }

    @Override
    public BookiesRackConfiguration deserialize(String key, byte[] content) throws Exception {
        LOG.info("Reloading the bookie isolation groups mapping cache.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading the bookie mappings with bookie info data: {}", (Object)new String(content));
        }
        return (BookiesRackConfiguration)this.jsonMapper.readValue(content, BookiesRackConfiguration.class);
    }
}

