/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreProvider;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogImpl;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLTransactionMetadataStoreProvider
implements TransactionMetadataStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(MLTransactionMetadataStoreProvider.class);

    @Override
    public CompletableFuture<TransactionMetadataStore> openStore(TransactionCoordinatorID transactionCoordinatorId, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig) {
        MLTransactionMetadataStore transactionMetadataStore;
        try {
            transactionMetadataStore = new MLTransactionMetadataStore(transactionCoordinatorId, new MLTransactionLogImpl(transactionCoordinatorId, managedLedgerFactory, managedLedgerConfig));
        }
        catch (Exception e) {
            log.error("MLTransactionMetadataStore init fail", (Throwable)e);
            return FutureUtil.failedFuture((Throwable)e);
        }
        return CompletableFuture.completedFuture(transactionMetadataStore);
    }
}

