/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.util;

import org.apache.pulsar.transaction.coordinator.proto.PulsarTransactionMetadata;

public class TransactionUtil {
    public static boolean canTransitionTo(PulsarTransactionMetadata.TxnStatus currentStatus, PulsarTransactionMetadata.TxnStatus newStatus) {
        switch (currentStatus) {
            case OPEN: {
                return newStatus != PulsarTransactionMetadata.TxnStatus.COMMITTED && newStatus != PulsarTransactionMetadata.TxnStatus.ABORTED;
            }
            case COMMITTING: {
                return newStatus == PulsarTransactionMetadata.TxnStatus.COMMITTING || newStatus == PulsarTransactionMetadata.TxnStatus.COMMITTED;
            }
            case COMMITTED: {
                return newStatus == PulsarTransactionMetadata.TxnStatus.COMMITTED;
            }
            case ABORTING: {
                return newStatus == PulsarTransactionMetadata.TxnStatus.ABORTING || newStatus == PulsarTransactionMetadata.TxnStatus.ABORTED;
            }
            case ABORTED: {
                return newStatus == PulsarTransactionMetadata.TxnStatus.ABORTED;
            }
        }
        throw new IllegalArgumentException("Unknown txn status : " + (Object)((Object)newStatus));
    }
}

