/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import io.netty.util.Recycler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.transaction.coordinator.TransactionSubscription;
import org.apache.pulsar.transaction.coordinator.TxnMeta;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.proto.PulsarTransactionMetadata;
import org.apache.pulsar.transaction.coordinator.util.TransactionUtil;

class TxnMetaImpl
implements TxnMeta {
    private TxnID txnID;
    private final Set<String> producedPartitions = new HashSet<String>();
    private final Set<TransactionSubscription> ackedPartitions = new HashSet<TransactionSubscription>();
    private volatile PulsarTransactionMetadata.TxnStatus txnStatus = PulsarTransactionMetadata.TxnStatus.OPEN;
    private final Recycler.Handle<TxnMetaImpl> recycleHandle;
    private static final Recycler<TxnMetaImpl> RECYCLER = new Recycler<TxnMetaImpl>(){

        protected TxnMetaImpl newObject(Recycler.Handle<TxnMetaImpl> handle) {
            return new TxnMetaImpl(handle);
        }
    };

    TxnMetaImpl(Recycler.Handle<TxnMetaImpl> handle) {
        this.recycleHandle = handle;
    }

    static TxnMetaImpl create(TxnID txnID) {
        TxnMetaImpl txnMeta = (TxnMetaImpl)RECYCLER.get();
        txnMeta.txnID = txnID;
        return txnMeta;
    }

    public void recycle() {
        this.producedPartitions.clear();
        this.ackedPartitions.clear();
        this.txnStatus = PulsarTransactionMetadata.TxnStatus.OPEN;
        if (this.recycleHandle != null) {
            this.recycleHandle.recycle((Object)this);
        }
    }

    @Override
    public TxnID id() {
        return this.txnID;
    }

    @Override
    public synchronized PulsarTransactionMetadata.TxnStatus status() {
        return this.txnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> producedPartitions() {
        ArrayList<String> returnedPartitions;
        TxnMetaImpl txnMetaImpl = this;
        synchronized (txnMetaImpl) {
            returnedPartitions = new ArrayList<String>(this.producedPartitions.size());
            returnedPartitions.addAll(this.producedPartitions);
        }
        Collections.sort(returnedPartitions);
        return returnedPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TransactionSubscription> ackedPartitions() {
        ArrayList<TransactionSubscription> returnedPartitions;
        TxnMetaImpl txnMetaImpl = this;
        synchronized (txnMetaImpl) {
            returnedPartitions = new ArrayList<TransactionSubscription>(this.ackedPartitions.size());
            returnedPartitions.addAll(this.ackedPartitions);
        }
        Collections.sort(returnedPartitions);
        return returnedPartitions;
    }

    private synchronized void checkTxnStatus(PulsarTransactionMetadata.TxnStatus expectedStatus) throws CoordinatorException.InvalidTxnStatusException {
        if (this.txnStatus != expectedStatus) {
            throw new CoordinatorException.InvalidTxnStatusException(this.txnID, expectedStatus, this.txnStatus);
        }
    }

    @Override
    public synchronized TxnMetaImpl addProducedPartitions(List<String> partitions) throws CoordinatorException.InvalidTxnStatusException {
        this.checkTxnStatus(PulsarTransactionMetadata.TxnStatus.OPEN);
        this.producedPartitions.addAll(partitions);
        return this;
    }

    @Override
    public synchronized TxnMetaImpl addAckedPartitions(List<TransactionSubscription> partitions) throws CoordinatorException.InvalidTxnStatusException {
        this.checkTxnStatus(PulsarTransactionMetadata.TxnStatus.OPEN);
        this.ackedPartitions.addAll(partitions);
        return this;
    }

    @Override
    public synchronized TxnMetaImpl updateTxnStatus(PulsarTransactionMetadata.TxnStatus newStatus, PulsarTransactionMetadata.TxnStatus expectedStatus) throws CoordinatorException.InvalidTxnStatusException {
        this.checkTxnStatus(expectedStatus);
        if (!TransactionUtil.canTransitionTo(this.txnStatus, newStatus)) {
            throw new CoordinatorException.InvalidTxnStatusException("Transaction `" + this.txnID + "` CANNOT transaction from status " + (Object)((Object)this.txnStatus) + " to " + (Object)((Object)newStatus));
        }
        this.txnStatus = newStatus;
        return this;
    }
}

