/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import java.util.Objects;

public class TransactionSubscription
implements Comparable<TransactionSubscription> {
    private String topic;
    private String subscription;

    public int hashCode() {
        return Objects.hash(this.topic, this.subscription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionSubscription that = (TransactionSubscription)o;
        return this.topic.equals(that.topic) && this.subscription.equals(that.subscription);
    }

    @Override
    public int compareTo(TransactionSubscription o) {
        int topicCompare = this.topic.compareTo(o.topic);
        if (topicCompare == 0) {
            return this.subscription.compareTo(o.subscription);
        }
        return topicCompare;
    }

    TransactionSubscription(String topic, String subscription) {
        this.topic = topic;
        this.subscription = subscription;
    }

    public static TransactionSubscriptionBuilder builder() {
        return new TransactionSubscriptionBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String toString() {
        return "TransactionSubscription(topic=" + this.getTopic() + ", subscription=" + this.getSubscription() + ")";
    }

    public static class TransactionSubscriptionBuilder {
        private String topic;
        private String subscription;

        TransactionSubscriptionBuilder() {
        }

        public TransactionSubscriptionBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TransactionSubscriptionBuilder subscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        public TransactionSubscription build() {
            return new TransactionSubscription(this.topic, this.subscription);
        }

        public String toString() {
            return "TransactionSubscription.TransactionSubscriptionBuilder(topic=" + this.topic + ", subscription=" + this.subscription + ")";
        }
    }
}

