package org.apache.pulsar.transaction.coordinator.proto;
public final class BatchedTransactionMetadataEntry {
	private java.util.List<TransactionMetadataEntry> transactionLogs = null;
	private int _transactionLogsCount = 0;
	private static final int _TRANSACTION_LOGS_FIELD_NUMBER = 1;
	private static final int _TRANSACTION_LOGS_TAG = (_TRANSACTION_LOGS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TRANSACTION_LOGS_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TRANSACTION_LOGS_TAG);
	public int getTransactionLogsCount() {
		return _transactionLogsCount;
	}
	public TransactionMetadataEntry getTransactionLogAt(int idx) {
		if (idx < 0 || idx >= _transactionLogsCount) {
			throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + _transactionLogsCount
					+ ") for field 'transaction_logs'");
		}
		return transactionLogs.get(idx);
	}
	public java.util.List<TransactionMetadataEntry> getTransactionLogsList() {
		if (_transactionLogsCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			return transactionLogs.subList(0, _transactionLogsCount);
		}
	}
	public TransactionMetadataEntry addTransactionLog() {
		if (transactionLogs == null) {
			transactionLogs = new java.util.ArrayList<TransactionMetadataEntry>();
		}
		if (transactionLogs.size() == _transactionLogsCount) {
			transactionLogs.add(new TransactionMetadataEntry());
		}
		_cachedSize = -1;
		return transactionLogs.get(_transactionLogsCount++);
	}
	public BatchedTransactionMetadataEntry addAllTransactionLogs(Iterable<TransactionMetadataEntry> transactionLogs) {
		for (TransactionMetadataEntry _o : transactionLogs) {
			addTransactionLog().copyFrom(_o);
		}
		return this;
	}
	public BatchedTransactionMetadataEntry clearTransactionLogs() {
		for (int i = 0; i < _transactionLogsCount; i++) {
			transactionLogs.get(i).clear();
		}
		_transactionLogsCount = 0;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0;
	public int writeTo(io.netty.buffer.ByteBuf _b) {
		int _writeIdx = _b.writerIndex();
		for (int i = 0; i < _transactionLogsCount; i++) {
			TransactionMetadataEntry _item = transactionLogs.get(i);
			LightProtoCodec.writeVarInt(_b, _TRANSACTION_LOGS_TAG);
			LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
			_item.writeTo(_b);
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		for (int i = 0; i < _transactionLogsCount; i++) {
			TransactionMetadataEntry _item = transactionLogs.get(i);
			_size += _TRANSACTION_LOGS_TAG_SIZE;
			int MsgsizeTransactionLogs = _item.getSerializedSize();
			_size += LightProtoCodec.computeVarIntSize(MsgsizeTransactionLogs) + MsgsizeTransactionLogs;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _TRANSACTION_LOGS_TAG :
					int _transactionLogsSize = LightProtoCodec.readVarInt(_buffer);
					addTransactionLog().parseFrom(_buffer, _transactionLogsSize);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		_parsedBuffer = _buffer;
	}
	public BatchedTransactionMetadataEntry clear() {
		for (int i = 0; i < _transactionLogsCount; i++) {
			transactionLogs.get(i).clear();
		}
		_transactionLogsCount = 0;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public BatchedTransactionMetadataEntry copyFrom(BatchedTransactionMetadataEntry _other) {
		_cachedSize = -1;
		for (int i = 0; i < _other.getTransactionLogsCount(); i++) {
			addTransactionLog().copyFrom(_other.getTransactionLogAt(i));
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private io.netty.buffer.ByteBuf _parsedBuffer;

}
