/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionLog;
import org.apache.pulsar.transaction.coordinator.TransactionLogReplayCallback;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogInterceptor;
import org.apache.pulsar.transaction.coordinator.proto.TransactionMetadataEntry;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLTransactionLogImpl
implements TransactionLog {
    private static final Logger log = LoggerFactory.getLogger(MLTransactionLogImpl.class);
    private final ManagedLedgerFactory managedLedgerFactory;
    private final ManagedLedgerConfig managedLedgerConfig;
    private ManagedLedger managedLedger;
    public static final String TRANSACTION_LOG_PREFIX = "__transaction_log_";
    private ManagedCursor cursor;
    public static final String TRANSACTION_SUBSCRIPTION_NAME = "transaction.subscription";
    private final SpscArrayQueue<Entry> entryQueue;
    private final long tcId;
    private final TopicName topicName;
    private final MLTransactionLogInterceptor mlTransactionLogInterceptor;

    public MLTransactionLogImpl(TransactionCoordinatorID tcID, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig) {
        this.topicName = MLTransactionLogImpl.getMLTransactionLogName(tcID);
        this.tcId = tcID.getId();
        this.mlTransactionLogInterceptor = new MLTransactionLogInterceptor();
        managedLedgerConfig.setManagedLedgerInterceptor((ManagedLedgerInterceptor)this.mlTransactionLogInterceptor);
        this.managedLedgerFactory = managedLedgerFactory;
        this.managedLedgerConfig = managedLedgerConfig;
        this.entryQueue = new SpscArrayQueue(2000);
    }

    public static TopicName getMLTransactionLogName(TransactionCoordinatorID tcID) {
        return TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)(TRANSACTION_LOG_PREFIX + tcID.getId()));
    }

    @Override
    public CompletableFuture<Void> initialize() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.managedLedgerFactory.asyncOpen(this.topicName.getPersistenceNamingEncoding(), this.managedLedgerConfig, new AsyncCallbacks.OpenLedgerCallback(){

            public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                MLTransactionLogImpl.this.managedLedger = ledger;
                MLTransactionLogImpl.this.managedLedger.asyncOpenCursor(MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, CommandSubscribe.InitialPosition.Earliest, new AsyncCallbacks.OpenCursorCallback(){

                    public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                        MLTransactionLogImpl.this.cursor = cursor;
                        future.complete(null);
                    }

                    public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                        future.completeExceptionally((Throwable)exception);
                    }
                }, null);
            }

            public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally((Throwable)exception);
            }
        }, null, null);
        return future;
    }

    @Override
    public void replayAsync(TransactionLogReplayCallback transactionLogReplayCallback) {
        new TransactionLogReplayer(transactionLogReplayCallback).start();
    }

    private void readAsync(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback readEntriesCallback) {
        this.cursor.asyncReadEntries(numberOfEntriesToRead, readEntriesCallback, (Object)System.nanoTime(), PositionImpl.latest);
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.managedLedger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeComplete(Object ctx) {
                log.info("Transaction log with tcId : {} close managedLedger successful!", (Object)MLTransactionLogImpl.this.tcId);
                completableFuture.complete(null);
            }

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Transaction log with tcId : {} close managedLedger fail!", (Object)MLTransactionLogImpl.this.tcId);
                completableFuture.completeExceptionally((Throwable)exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Position> append(final TransactionMetadataEntry transactionMetadataEntry) {
        int transactionMetadataEntrySize = transactionMetadataEntry.getSerializedSize();
        final ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(transactionMetadataEntrySize, transactionMetadataEntrySize);
        final CompletableFuture<Position> completableFuture = new CompletableFuture<Position>();
        transactionMetadataEntry.writeTo(buf);
        this.managedLedger.asyncAddEntry(buf, new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                buf.release();
                MLTransactionLogImpl.this.mlTransactionLogInterceptor.setMaxLocalTxnId(transactionMetadataEntry.getMaxLocalTxnId());
                completableFuture.complete(position);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Transaction log write transaction operation error", (Throwable)exception);
                if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException && MLTransactionLogImpl.this.managedLedger instanceof ManagedLedgerImpl && ManagedLedgerImpl.State.WriteFailed == ((ManagedLedgerImpl)MLTransactionLogImpl.this.managedLedger).getState()) {
                    MLTransactionLogImpl.this.managedLedger.readyToCreateNewLedger();
                }
                buf.release();
                completableFuture.completeExceptionally((Throwable)exception);
            }
        }, null);
        return completableFuture;
    }

    public CompletableFuture<Void> deletePosition(List<Position> positions) {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.cursor.asyncDelete(positions, new AsyncCallbacks.DeleteCallback(){

            public void deleteComplete(Object position) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Deleted message at {}", new Object[]{MLTransactionLogImpl.this.topicName, MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, position});
                }
                completableFuture.complete(null);
            }

            public void deleteFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}][{}] Failed to delete message at {}", new Object[]{MLTransactionLogImpl.this.topicName, MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, ctx, exception});
                completableFuture.completeExceptionally((Throwable)exception);
            }
        }, null);
        return completableFuture;
    }

    public ManagedLedger getManagedLedger() {
        return this.managedLedger;
    }

    public CompletableFuture<Long> getMaxLocalTxnId() {
        final CompletableFuture<Long> completableFuture = new CompletableFuture<Long>();
        PositionImpl position = (PositionImpl)this.managedLedger.getLastConfirmedEntry();
        if (position != null && position.getEntryId() != -1L && ((ManagedLedgerImpl)this.managedLedger).ledgerExists(position.getLedgerId())) {
            ((ManagedLedgerImpl)this.managedLedger).asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

                public void readEntryComplete(Entry entry, Object ctx) {
                    TransactionMetadataEntry lastConfirmEntry = new TransactionMetadataEntry();
                    ByteBuf buffer = entry.getDataBuffer();
                    lastConfirmEntry.parseFrom(buffer, buffer.readableBytes());
                    completableFuture.complete(lastConfirmEntry.getMaxLocalTxnId());
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}] MLTransactionLog recover MaxLocalTxnId fail!", (Object)MLTransactionLogImpl.this.topicName, (Object)exception);
                    completableFuture.completeExceptionally((Throwable)exception);
                }
            }, null);
        } else if (this.managedLedger.getProperties().get("max_local_txn_id") != null) {
            completableFuture.complete(Long.parseLong((String)this.managedLedger.getProperties().get("max_local_txn_id")));
        } else {
            log.error("[{}] MLTransactionLog recover MaxLocalTxnId fail! not found MaxLocalTxnId in managedLedger and properties", (Object)this.topicName);
            completableFuture.completeExceptionally((Throwable)new ManagedLedgerException(this.topicName + "MLTransactionLog recover MaxLocalTxnId fail! not found MaxLocalTxnId in managedLedger and properties"));
        }
        return completableFuture;
    }

    class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);

        FillEntryQueueCallback() {
        }

        boolean fillQueue() {
            if (MLTransactionLogImpl.this.entryQueue.size() < MLTransactionLogImpl.this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L) {
                if (MLTransactionLogImpl.this.cursor.hasMoreEntries()) {
                    this.outstandingReadsRequests.incrementAndGet();
                    MLTransactionLogImpl.this.readAsync(100, this);
                    return true;
                }
                return false;
            }
            return true;
        }

        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            MLTransactionLogImpl.this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            log.error("Transaction log init fail error!", (Throwable)exception);
            this.outstandingReadsRequests.decrementAndGet();
        }
    }

    class TransactionLogReplayer {
        private final FillEntryQueueCallback fillEntryQueueCallback;
        private final TransactionLogReplayCallback transactionLogReplayCallback;

        TransactionLogReplayer(TransactionLogReplayCallback transactionLogReplayCallback) {
            this.fillEntryQueueCallback = new FillEntryQueueCallback();
            this.transactionLogReplayCallback = transactionLogReplayCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            TransactionMetadataEntry transactionMetadataEntry = new TransactionMetadataEntry();
            while (this.fillEntryQueueCallback.fillQueue() || MLTransactionLogImpl.this.entryQueue.size() > 0) {
                Entry entry = (Entry)MLTransactionLogImpl.this.entryQueue.poll();
                if (entry != null) {
                    try {
                        ByteBuf buffer = entry.getDataBuffer();
                        transactionMetadataEntry.parseFrom(buffer, buffer.readableBytes());
                        this.transactionLogReplayCallback.handleMetadataEntry(entry.getPosition(), transactionMetadataEntry);
                        continue;
                    }
                    finally {
                        entry.release();
                        continue;
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.transactionLogReplayCallback.replayComplete();
        }
    }
}

