/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf gen-doc");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        LinkedHashMap cmdClassMap = new LinkedHashMap();
        cmdClassMap.put("produce", Class.forName("org.apache.pulsar.testclient.PerformanceProducer$Arguments"));
        cmdClassMap.put("consume", Class.forName("org.apache.pulsar.testclient.PerformanceConsumer$Arguments"));
        cmdClassMap.put("transaction", Class.forName("org.apache.pulsar.testclient.PerformanceTransaction$Arguments"));
        cmdClassMap.put("read", Class.forName("org.apache.pulsar.testclient.PerformanceReader$Arguments"));
        cmdClassMap.put("monitor-brokers", Class.forName("org.apache.pulsar.testclient.BrokerMonitor$Arguments"));
        cmdClassMap.put("simulation-client", Class.forName("org.apache.pulsar.testclient.LoadSimulationClient$MainArguments"));
        cmdClassMap.put("simulation-controller", Class.forName("org.apache.pulsar.testclient.LoadSimulationController$MainArguments"));
        cmdClassMap.put("websocket-producer", Class.forName("org.apache.pulsar.proxy.socket.client.PerformanceClient$Arguments"));
        cmdClassMap.put("managed-ledger", Class.forName("org.apache.pulsar.testclient.ManagedLedgerWriter$Arguments"));
        for (Map.Entry entry : cmdClassMap.entrySet()) {
            String cmd = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            jc.addCommand(cmd, constructor.newInstance(new Object[0]));
        }
        if (arguments.commandNames.size() == 0) {
            for (Map.Entry entry : jc.getCommands().entrySet()) {
                CmdGenerateDocumentation.generateDocument((String)entry.getKey(), jc);
            }
        } else {
            for (String string : arguments.commandNames) {
                CmdGenerateDocumentation.generateDocument(string, jc);
            }
        }
    }

    private static String generateDocument(String module, JCommander parentCmd) {
        StringBuilder sb = new StringBuilder();
        JCommander cmd = (JCommander)parentCmd.getCommands().get(module);
        sb.append("------------\n\n");
        sb.append("# ").append(module).append("\n\n");
        sb.append("### Usage\n\n");
        sb.append("`$").append(module).append("`\n\n");
        sb.append("------------\n\n");
        sb.append(parentCmd.getUsageFormatter().getCommandDescription(module)).append("\n");
        sb.append("\n\n```bdocs-tab:example_shell\n").append("$ pulsar-perf ").append(module).append(" [options]").append("\n```");
        sb.append("\n\n");
        for (String s : cmd.getCommands().keySet()) {
            sb.append("* `").append(s).append("`\n");
        }
        sb.append("|Flag|Description|Default|\n");
        sb.append("|---|---|---|\n");
        List options = cmd.getParameters();
        options.stream().filter(ele -> !ele.getParameterAnnotation().hidden()).forEach(option -> sb.append("| `").append(option.getNames()).append("` | ").append(option.getDescription().replace("\n", " ")).append("|").append(option.getDefault()).append("|\n"));
        System.out.println(sb.toString());
        return sb.toString();
    }

    @Parameters(commandDescription="Generate documentation automatically.")
    static class Arguments {
        @Parameter(names={"-h", "--help"}, description="Help message", help=true)
        boolean help;
        @Parameter(names={"-n", "--command-names"}, description="List of command names")
        private List<String> commandNames = new ArrayList<String>();

        Arguments() {
        }
    }
}

