/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.pulsar.testclient.IMessageFormatter;

public class DefaultMessageFormatter
implements IMessageFormatter {
    private final Random r = new Random();

    @Override
    public byte[] formatMessage(String producerName, long msgId, byte[] message) {
        String sMessage = new String(message, StandardCharsets.UTF_8);
        if (producerName != null && !producerName.isEmpty()) {
            sMessage = sMessage.replaceAll("%p", producerName);
        }
        sMessage = sMessage.replaceAll("%i", String.valueOf(msgId));
        sMessage = sMessage.replaceAll("%t", String.valueOf(System.nanoTime()));
        int idx = sMessage.indexOf("%");
        while (idx > 0) {
            char c;
            float size = 0.0f;
            int i = 1;
            while (idx + i < sMessage.length() && (Character.isDigit(c = sMessage.charAt(idx + i)) && c != '.' || c == '.' || c == '-')) {
                ++i;
            }
            if (i != 1) {
                size = Float.parseFloat(sMessage.substring(idx + 1, idx + i));
            }
            String sub = sMessage.substring(idx, idx + i + 1);
            if (sMessage.charAt(idx + i) == 'f') {
                sMessage = sMessage.replaceFirst(sub, this.getFloatValue(size));
            } else if (sMessage.charAt(idx + i) == 'l') {
                sMessage = sMessage.replaceFirst(sub, this.getLongValue(size));
            } else if (sMessage.charAt(idx + i) == 'd') {
                sMessage = sMessage.replaceFirst(sub, this.getIntValue(size));
            } else if (sMessage.charAt(idx + i) == 's') {
                sMessage = sMessage.replaceFirst(sub, this.getStringValue(size));
            }
            idx = sMessage.indexOf("%", idx);
        }
        return sMessage.getBytes(StandardCharsets.UTF_8);
    }

    private float get_FloatValue(float size) {
        float f = this.r.nextFloat();
        int mag = (int)Math.abs(size);
        if (size < 0.0f && (int)(f *= (float)Math.pow(10.0, mag)) % 2 == 1) {
            return f * -1.0f;
        }
        return f;
    }

    private String getStringValue(float size) {
        return RandomStringUtils.randomAlphabetic((int)((int)size));
    }

    private String getFloatValue(float size) {
        if (size == 0.0f) {
            return String.valueOf(this.r.nextFloat());
        }
        String format = "%" + size + "f";
        return String.format(format, Float.valueOf(this.get_FloatValue(size)));
    }

    private String getIntValue(float size) {
        int i = 0;
        if (size != 0.0f) {
            i = (int)this.get_FloatValue(size);
        }
        if (i == 0) {
            i = this.r.nextInt() + 1;
        }
        return String.valueOf(i);
    }

    private String getLongValue(float size) {
        if (size == 0.0f) {
            return String.valueOf(this.r.nextLong());
        }
        return String.valueOf((long)this.get_FloatValue(size));
    }
}

