/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.curator.shaded.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceProducer;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceTransaction {
    private static final LongAdder totalNumEndTxnOpFailed = new LongAdder();
    private static final LongAdder totalNumEndTxnOpSuccess = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnSuccess = new LongAdder();
    private static final LongAdder numMessagesAckFailed = new LongAdder();
    private static final LongAdder numMessagesAckSuccess = new LongAdder();
    private static final LongAdder numMessagesSendFailed = new LongAdder();
    private static final LongAdder numMessagesSendSuccess = new LongAdder();
    private static final Recorder messageAckRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageAckCumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageSendRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageSendRCumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    static final DecimalFormat dec = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat intFormat = new PaddingDecimalFormat("0", 7);
    static final DecimalFormat totalFormat = new DecimalFormat("0.000");
    private static final Logger log = LoggerFactory.getLogger(PerformanceProducer.class);

    public static void main(String[] args) throws IOException, PulsarAdminException, ExecutionException, InterruptedException {
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf transaction");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.confFile != null) {
            Properties prop = new Properties(System.getProperties());
            prop.load(new FileInputStream(arguments.confFile));
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("brokerServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("serviceUrl", "http://localhost:8080/");
            }
            if (arguments.adminURL == null) {
                arguments.adminURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.adminURL == null) {
                arguments.adminURL = prop.getProperty("adminURL", "http://localhost:8080/");
            }
        }
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar perf transaction with config: {}", (Object)w.writeValueAsString((Object)arguments));
        byte[] payloadBytes = new byte[1024];
        Random random = new Random(0L);
        for (int i = 0; i < payloadBytes.length; ++i) {
            payloadBytes[i] = (byte)(random.nextInt(26) + 65);
        }
        if (arguments.partitions != null) {
            PulsarAdminBuilder clientBuilder = PulsarAdmin.builder().serviceHttpUrl(arguments.adminURL);
            try (PulsarAdmin client = clientBuilder.build();){
                for (String topic : arguments.producerTopic) {
                    log.info("Creating  produce partitioned topic {} with {} partitions", (Object)topic, (Object)arguments.partitions);
                    try {
                        client.topics().createPartitionedTopic(topic, arguments.partitions.intValue());
                    }
                    catch (PulsarAdminException.ConflictException alreadyExists) {
                        if (log.isDebugEnabled()) {
                            log.debug("Topic {} already exists: {}", (Object)topic, (Object)alreadyExists);
                        }
                        PartitionedTopicMetadata partitionedTopicMetadata = client.topics().getPartitionedTopicMetadata(topic);
                        if (partitionedTopicMetadata.partitions == arguments.partitions) continue;
                        log.error("Topic {} already exists but it has a wrong number of partitions: {}, expecting {}", new Object[]{topic, partitionedTopicMetadata.partitions, arguments.partitions});
                        PerfClientUtils.exit(-1);
                    }
                }
            }
        }
        PulsarClient client = PulsarClient.builder().enableTransaction(!arguments.isDisableTransaction).serviceUrl(arguments.serviceURL).connectionsPerBroker(arguments.maxConnections).statsInterval(0L, TimeUnit.SECONDS).ioThreads(arguments.ioThreads).build();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(arguments.numTestThreads, arguments.numTestThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        long startTime = System.nanoTime();
        long testEndTime = startTime + (long)((double)arguments.testTime * 1.0E9);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!arguments.isDisableTransaction) {
                PerformanceTransaction.printTxnAggregatedThroughput(startTime);
            } else {
                PerformanceTransaction.printAggregatedThroughput(startTime);
            }
            PerformanceTransaction.printAggregatedStats();
        }));
        AtomicBoolean executing = new AtomicBoolean(true);
        RateLimiter rateLimiter = arguments.openTxnRate > 0 ? RateLimiter.create((double)arguments.openTxnRate) : null;
        for (int i = 0; i < arguments.numTestThreads; ++i) {
            executorService.submit(() -> {
                List<Producer<byte[]>> producers = null;
                List<List<Consumer<byte[]>>> consumers = null;
                AtomicReference<Object> atomicReference = null;
                try {
                    producers = PerformanceTransaction.buildProducers(client, arguments);
                    consumers = PerformanceTransaction.buildConsumer(client, arguments);
                    atomicReference = !arguments.isDisableTransaction ? new AtomicReference(client.newTransaction().withTransactionTimeout(arguments.transactionTimeout, TimeUnit.SECONDS).build().get()) : new AtomicReference<Object>(null);
                }
                catch (Exception e) {
                    log.error("Failed to build Producer/Consumer with exception : ", (Throwable)e);
                    executorService.shutdownNow();
                    PerfClientUtils.exit(-1);
                }
                block6: while (true) {
                    if (arguments.numTransactions > 0L && totalNumTxnOpenTxnFail.sum() + totalNumTxnOpenTxnSuccess.sum() >= arguments.numTransactions) {
                        if (totalNumEndTxnOpFailed.sum() + totalNumEndTxnOpSuccess.sum() < arguments.numTransactions) continue;
                        log.info("------------------- DONE -----------------------");
                        executing.compareAndSet(true, false);
                        executorService.shutdownNow();
                        PerfClientUtils.exit(0);
                        break;
                    }
                    if (arguments.testTime > 0L && System.nanoTime() > testEndTime) {
                        log.info("------------------- DONE -----------------------");
                        executing.compareAndSet(true, false);
                        executorService.shutdownNow();
                        PerfClientUtils.exit(0);
                        break;
                    }
                    Transaction transaction = atomicReference.get();
                    for (List<Consumer<byte[]>> list : consumers) {
                        for (Consumer<byte[]> consumer : list) {
                            for (int j = 0; j < arguments.numMessagesReceivedPerTransaction; ++j) {
                                Message message = null;
                                try {
                                    message = consumer.receive();
                                }
                                catch (PulsarClientException e) {
                                    log.error("Receive message failed", (Throwable)e);
                                    executorService.shutdownNow();
                                    PerfClientUtils.exit(-1);
                                }
                                long receiveTime = System.nanoTime();
                                if (!arguments.isDisableTransaction) {
                                    ((CompletableFuture)consumer.acknowledgeAsync(message.getMessageId(), transaction).thenRun(() -> {
                                        long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - receiveTime);
                                        messageAckRecorder.recordValue(latencyMicros);
                                        messageAckCumulativeRecorder.recordValue(latencyMicros);
                                        numMessagesAckSuccess.increment();
                                    })).exceptionally(exception -> {
                                        if (exception instanceof InterruptedException && !executing.get()) {
                                            return null;
                                        }
                                        log.error("Ack message failed with transaction {} throw exception", (Object)transaction, exception);
                                        numMessagesAckFailed.increment();
                                        return null;
                                    });
                                    continue;
                                }
                                ((CompletableFuture)consumer.acknowledgeAsync(message).thenRun(() -> {
                                    long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - receiveTime);
                                    messageAckRecorder.recordValue(latencyMicros);
                                    messageAckCumulativeRecorder.recordValue(latencyMicros);
                                    numMessagesAckSuccess.increment();
                                })).exceptionally(exception -> {
                                    if (exception instanceof InterruptedException && !executing.get()) {
                                        return null;
                                    }
                                    log.error("Ack message failed with transaction {} throw exception", (Object)transaction, exception);
                                    numMessagesAckFailed.increment();
                                    return null;
                                });
                            }
                        }
                    }
                    for (Producer producer : producers) {
                        for (int j = 0; j < arguments.numMessagesProducedPerTransaction; ++j) {
                            long sendTime = System.nanoTime();
                            if (!arguments.isDisableTransaction) {
                                ((CompletableFuture)producer.newMessage(transaction).value((Object)payloadBytes).sendAsync().thenRun(() -> {
                                    long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                                    messageSendRecorder.recordValue(latencyMicros);
                                    messageSendRCumulativeRecorder.recordValue(latencyMicros);
                                    numMessagesSendSuccess.increment();
                                })).exceptionally(exception -> {
                                    if (exception instanceof InterruptedException && !executing.get()) {
                                        return null;
                                    }
                                    log.error("Send transaction message failed with exception : ", exception);
                                    numMessagesSendFailed.increment();
                                    return null;
                                });
                                continue;
                            }
                            ((CompletableFuture)producer.newMessage().value((Object)payloadBytes).sendAsync().thenRun(() -> {
                                long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                                messageSendRecorder.recordValue(latencyMicros);
                                messageSendRCumulativeRecorder.recordValue(latencyMicros);
                                numMessagesSendSuccess.increment();
                            })).exceptionally(exception -> {
                                if (exception instanceof InterruptedException && !executing.get()) {
                                    return null;
                                }
                                log.error("Send message failed with exception : ", exception);
                                numMessagesSendFailed.increment();
                                return null;
                            });
                        }
                    }
                    if (rateLimiter != null) {
                        rateLimiter.tryAcquire();
                    }
                    if (!arguments.isDisableTransaction) {
                        if (!arguments.isAbortTransaction) {
                            ((CompletableFuture)transaction.commit().thenRun(() -> {
                                numTxnOpSuccess.increment();
                                totalNumEndTxnOpSuccess.increment();
                            })).exceptionally(exception -> {
                                if (exception instanceof InterruptedException && !executing.get()) {
                                    return null;
                                }
                                log.error("Commit transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                                totalNumEndTxnOpFailed.increment();
                                return null;
                            });
                        } else {
                            ((CompletableFuture)transaction.abort().thenRun(() -> {
                                numTxnOpSuccess.increment();
                                totalNumEndTxnOpSuccess.increment();
                            })).exceptionally(exception -> {
                                if (exception instanceof InterruptedException && !executing.get()) {
                                    return null;
                                }
                                log.error("Commit transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                                totalNumEndTxnOpFailed.increment();
                                return null;
                            });
                        }
                        while (true) {
                            try {
                                Transaction newTransaction = (Transaction)client.newTransaction().withTransactionTimeout(arguments.transactionTimeout, TimeUnit.SECONDS).build().get();
                                atomicReference.compareAndSet(transaction, newTransaction);
                                totalNumTxnOpenTxnSuccess.increment();
                                continue block6;
                            }
                            catch (Exception throwable) {
                                if (throwable instanceof InterruptedException && !executing.get()) continue block6;
                                log.error("Failed to new transaction with exception: ", (Throwable)throwable);
                                totalNumTxnOpenTxnFail.increment();
                                continue;
                            }
                            break;
                        }
                    }
                    totalNumTxnOpenTxnSuccess.increment();
                    totalNumEndTxnOpSuccess.increment();
                    numTxnOpSuccess.increment();
                }
            });
        }
        long oldTime = System.nanoTime();
        Histogram reportSendHistogram = null;
        Histogram reportAckHistogram = null;
        String statsFileName = "perf-transaction-" + System.currentTimeMillis() + ".hgrm";
        log.info("Dumping latency stats to {}", (Object)statsFileName);
        PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
        HistogramLogWriter histogramLogWriter = new HistogramLogWriter(histogramLog);
        histogramLogWriter.outputLogFormatVersion();
        histogramLogWriter.outputLegend();
        while (executing.get()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalNumEndTxnOpFailed.sum() + totalNumTxnOpenTxnSuccess.sum();
            double rate = (double)numTxnOpSuccess.sumThenReset() / elapsed;
            reportSendHistogram = messageSendRecorder.getIntervalHistogram(reportSendHistogram);
            reportAckHistogram = messageAckRecorder.getIntervalHistogram(reportAckHistogram);
            String txnOrTaskLog = !arguments.isDisableTransaction ? "Throughput transaction: {} transaction executes --- {} transaction/s" : "Throughput task: {} task executes --- {} task/s";
            log.info(txnOrTaskLog + "  --- send Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {} --- ack Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{intFormat.format(total), dec.format(rate), dec.format(reportSendHistogram.getMean() / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportSendHistogram.getMaxValue() / 1000.0), dec.format(reportAckHistogram.getMean() / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportAckHistogram.getMaxValue() / 1000.0)});
            histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportSendHistogram);
            histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportAckHistogram);
            reportSendHistogram.reset();
            reportAckHistogram.reset();
            oldTime = now;
        }
    }

    private static void printTxnAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        long numTransactionEndFailed = totalNumEndTxnOpFailed.sum();
        long numTransactionEndSuccess = totalNumEndTxnOpSuccess.sum();
        long total = numTransactionEndFailed + numTransactionEndSuccess;
        double rate = (double)total / elapsed;
        long numMessageAckFailed = numMessagesAckFailed.sum();
        long numMessageAckSuccess = numMessagesAckSuccess.sum();
        long numMessageSendFailed = numMessagesSendFailed.sum();
        long numMessageSendSuccess = numMessagesSendSuccess.sum();
        long numTransactionOpenFailed = totalNumTxnOpenTxnFail.sum();
        long numTransactionOpenSuccess = totalNumTxnOpenTxnSuccess.sum();
        log.info("Aggregated throughput stats --- {} transaction executed --- {} transaction/s  --- {} transaction open successfully --- {} transaction open failed --- {} transaction end successfully --- {} transaction end failed --- {} message ack failed --- {} message send failed --- {} message ack success --- {} message send success ", new Object[]{total, dec.format(rate), numTransactionOpenSuccess, numTransactionOpenFailed, numTransactionEndSuccess, numTransactionEndFailed, numMessageAckFailed, numMessageSendFailed, numMessageAckSuccess, numMessageSendSuccess});
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        long total = totalNumEndTxnOpFailed.sum() + totalNumEndTxnOpSuccess.sum();
        double rate = (double)total / elapsed;
        long numMessageAckFailed = numMessagesAckFailed.sum();
        long numMessageAckSuccess = numMessagesAckSuccess.sum();
        long numMessageSendFailed = numMessagesSendFailed.sum();
        long numMessageSendSuccess = numMessagesSendSuccess.sum();
        log.info("Aggregated throughput stats --- {} task executed --- {} task/s --- {} message ack failed --- {} message send failed --- {} message ack success --- {} message send success", new Object[]{total, totalFormat.format(rate), numMessageAckFailed, numMessageSendFailed, numMessageAckSuccess, numMessageSendSuccess});
    }

    private static void printAggregatedStats() {
        Histogram reportAckHistogram = messageAckCumulativeRecorder.getIntervalHistogram();
        Histogram reportSendHistogram = messageSendRCumulativeRecorder.getIntervalHistogram();
        log.info("Messages ack aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportAckHistogram.getMean() / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportAckHistogram.getValueAtPercentile(99.999) / 1000.0), dec.format((double)reportAckHistogram.getMaxValue() / 1000.0)});
        log.info("Messages send aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportSendHistogram.getMean() / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportSendHistogram.getValueAtPercentile(99.999) / 1000.0), dec.format((double)reportSendHistogram.getMaxValue() / 1000.0)});
    }

    private static List<List<Consumer<byte[]>>> buildConsumer(PulsarClient client, Arguments arguments) throws ExecutionException, InterruptedException {
        ConsumerBuilder consumerBuilder = client.newConsumer(Schema.BYTES).subscriptionType(arguments.subscriptionType).receiverQueueSize(arguments.receiverQueueSize).subscriptionInitialPosition(arguments.subscriptionInitialPosition);
        Iterator<String> consumerTopicsIterator = arguments.consumerTopic.iterator();
        ArrayList<List<Consumer<byte[]>>> consumers = new ArrayList<List<Consumer<byte[]>>>(arguments.consumerTopic.size());
        while (consumerTopicsIterator.hasNext()) {
            String topic = consumerTopicsIterator.next();
            ArrayList subscriptions = new ArrayList(arguments.numSubscriptions);
            ArrayList<CompletableFuture> subscriptionFutures = new ArrayList<CompletableFuture>(arguments.numSubscriptions);
            log.info("Create subscriptions for topic {}", (Object)topic);
            for (int j = 0; j < arguments.numSubscriptions; ++j) {
                String string = arguments.subscriptions.get(j);
                subscriptionFutures.add(consumerBuilder.clone().topic(new String[]{topic}).subscriptionName(string).subscribeAsync());
            }
            for (Future future : subscriptionFutures) {
                subscriptions.add(future.get());
            }
            consumers.add(subscriptions);
        }
        return consumers;
    }

    private static List<Producer<byte[]>> buildProducers(PulsarClient client, Arguments arguments) throws ExecutionException, InterruptedException {
        ProducerBuilder producerBuilder = client.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS);
        ArrayList<CompletableFuture> producerFutures = new ArrayList<CompletableFuture>();
        for (String topic : arguments.producerTopic) {
            log.info("Create producer for topic {}", (Object)topic);
            producerFutures.add(producerBuilder.clone().topic(topic).createAsync());
        }
        ArrayList<Producer<byte[]>> producers = new ArrayList<Producer<byte[]>>(producerFutures.size());
        for (Future future : producerFutures) {
            producers.add((Producer<byte[]>)future.get());
        }
        return producers;
    }

    @Parameters(commandDescription="Test pulsar transaction performance.")
    static class Arguments {
        @Parameter(names={"-h", "--help"}, description="Help message", help=true)
        boolean help;
        @Parameter(names={"--conf-file"}, description="Configuration file")
        public String confFile;
        @Parameter(names={"--topics-c"}, description="All topics that need ack for a transaction", required=true)
        public List<String> consumerTopic = Collections.singletonList("test-consume");
        @Parameter(names={"--topics-p"}, description="All topics that need produce for a transaction", required=true)
        public List<String> producerTopic = Collections.singletonList("test-produce");
        @Parameter(names={"-threads", "--num-test-threads"}, description="Number of test threads.This thread is for a new transaction to ack messages from consumer topics and produce message to producer topics, and then commit or abort this transaction. Increasing the number of threads increases the parallelism of the performance test, thereby increasing the intensity of the stress test.")
        public int numTestThreads = 1;
        @Parameter(names={"-au", "--admin-url"}, description="Pulsar Admin URL")
        public String adminURL;
        @Parameter(names={"-u", "--service-url"}, description="Pulsar Service URL")
        public String serviceURL;
        @Parameter(names={"-np", "--partitions"}, description="Create partitioned topics with a given number of partitions, 0 meansnot trying to create a topic")
        public Integer partitions = null;
        @Parameter(names={"-c", "--max-connections"}, description="Max number of TCP connections to a single broker")
        public int maxConnections = 100;
        @Parameter(names={"-time", "--test-duration"}, description="Test duration (in second). 0 means keeping publishing")
        public long testTime = 0L;
        @Parameter(names={"-ioThreads", "--num-io-threads"}, description="Set the number of threads to be used for handling connections to brokers. The default value is 1.")
        public int ioThreads = 1;
        @Parameter(names={"-ss", "--subscriptions"}, description="A list of subscriptions to consume (for example, sub1,sub2)")
        public List<String> subscriptions = Collections.singletonList("sub");
        @Parameter(names={"-ns", "--num-subscriptions"}, description="Number of subscriptions (per topic)")
        public int numSubscriptions = 1;
        @Parameter(names={"-sp", "--subscription-position"}, description="Subscription position")
        private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Earliest;
        @Parameter(names={"-st", "--subscription-type"}, description="Subscription type")
        public SubscriptionType subscriptionType = SubscriptionType.Shared;
        @Parameter(names={"-q", "--receiver-queue-size"}, description="Size of the receiver queue")
        public int receiverQueueSize = 1000;
        @Parameter(names={"-tto", "--txn-timeout"}, description="Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)")
        public long transactionTimeout = 5L;
        @Parameter(names={"-ntxn", "--number-txn"}, description="Set the number of transaction. 0 means keeping open.If transaction disabled, it means the number of tasks. The task or transaction produces or consumes a specified number of messages.")
        public long numTransactions = 0L;
        @Parameter(names={"-nmp", "--numMessage-perTransaction-produce"}, description="Set the number of messages produced in  a transaction.If transaction disabled, it means the number of messages produced in a task.")
        public int numMessagesProducedPerTransaction = 1;
        @Parameter(names={"-nmc", "--numMessage-perTransaction-consume"}, description="Set the number of messages consumed in a transaction.If transaction disabled, it means the number of messages consumed in a task.")
        public int numMessagesReceivedPerTransaction = 1;
        @Parameter(names={"--txn-disable"}, description="Disable transaction")
        public boolean isDisableTransaction = false;
        @Parameter(names={"-abort"}, description="Abort the transaction. (After --txn-disEnable setting to false, -abort takes effect)")
        public boolean isAbortTransaction = false;
        @Parameter(names={"-txnRate"}, description="Set the rate of opened transaction or task. 0 means no limit")
        public int openTxnRate = 0;

        Arguments() {
        }
    }
}

