/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.testclient.PerformanceProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceUtils {
    private static final Logger log = LoggerFactory.getLogger(PerformanceProducer.class);

    public static AtomicReference<Transaction> buildTransaction(PulsarClient pulsarClient, boolean isEnableTransaction, long transactionTimeout) {
        AtomicLong numBuildTxnFailed = new AtomicLong();
        if (isEnableTransaction) {
            AtomicReference<Transaction> atomicReference;
            do {
                atomicReference = null;
                try {
                    atomicReference = new AtomicReference<Transaction>((Transaction)pulsarClient.newTransaction().withTransactionTimeout(transactionTimeout, TimeUnit.SECONDS).build().get());
                }
                catch (Exception e) {
                    numBuildTxnFailed.incrementAndGet();
                    if (numBuildTxnFailed.get() % 10L != 0L) continue;
                    log.error("Failed to new a transaction with {} times", (Object)numBuildTxnFailed.get(), (Object)e);
                }
            } while (atomicReference == null || atomicReference.get() == null);
            log.info("After {} failures, the transaction was created successfully for the first time", (Object)numBuildTxnFailed.get());
            return atomicReference;
        }
        return new AtomicReference<Object>(null);
    }
}

