/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.io.FileInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PositiveNumberParameterValidator;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceReader {
    private static final LongAdder messagesReceived = new LongAdder();
    private static final LongAdder bytesReceived = new LongAdder();
    private static final DecimalFormat intFormat = new PaddingDecimalFormat("0", 7);
    private static final DecimalFormat dec = new DecimalFormat("0.000");
    private static final LongAdder totalMessagesReceived = new LongAdder();
    private static final LongAdder totalBytesReceived = new LongAdder();
    private static Recorder recorder = new Recorder(TimeUnit.DAYS.toMillis(10L), 5);
    private static Recorder cumulativeRecorder = new Recorder(TimeUnit.DAYS.toMillis(10L), 5);
    private static final Logger log = LoggerFactory.getLogger(PerformanceReader.class);

    public static void main(String[] args) throws Exception {
        MessageId startMessageId;
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf read");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(-1);
        }
        if (arguments.topic != null && arguments.topic.size() != arguments.numTopics) {
            if (arguments.topic.size() == 1) {
                String prefixTopicName = arguments.topic.get(0);
                ArrayList defaultTopics = Lists.newArrayList();
                for (int i = 0; i < arguments.numTopics; ++i) {
                    defaultTopics.add(String.format("%s-%d", prefixTopicName, i));
                }
                arguments.topic = defaultTopics;
            } else {
                System.out.println("The size of topics list should be equal to --num-topics");
                jc.usage();
                PerfClientUtils.exit(-1);
            }
        }
        if (arguments.confFile != null) {
            Properties prop = new Properties(System.getProperties());
            prop.load(new FileInputStream(arguments.confFile));
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("brokerServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("webServiceUrl");
            }
            if (arguments.serviceURL == null) {
                arguments.serviceURL = prop.getProperty("serviceUrl", "http://localhost:8080/");
            }
            if (arguments.authPluginClassName == null) {
                arguments.authPluginClassName = prop.getProperty("authPlugin", null);
            }
            if (arguments.authParams == null) {
                arguments.authParams = prop.getProperty("authParams", null);
            }
            if (!arguments.useTls) {
                arguments.useTls = Boolean.parseBoolean(prop.getProperty("useTls"));
            }
            if (StringUtils.isBlank((CharSequence)arguments.tlsTrustCertsFilePath)) {
                arguments.tlsTrustCertsFilePath = prop.getProperty("tlsTrustCertsFilePath", "");
            }
            if (arguments.tlsAllowInsecureConnection == null) {
                arguments.tlsAllowInsecureConnection = Boolean.parseBoolean(prop.getProperty("tlsAllowInsecureConnection", ""));
            }
        }
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar performance reader with config: {}", (Object)w.writeValueAsString((Object)arguments));
        RateLimiter limiter = arguments.rate > 0.0 ? RateLimiter.create((double)arguments.rate) : null;
        long startTime = System.nanoTime();
        long testEndTime = startTime + (long)((double)arguments.testTime * 1.0E9);
        ReaderListener & Serializable listener = (ReaderListener & Serializable)(reader, msg) -> {
            long latencyMillis;
            if (arguments.testTime > 0L && System.nanoTime() > testEndTime) {
                log.info("------------- DONE (reached the maximum duration: [{} seconds] of consumption) --------------", (Object)arguments.testTime);
                PerfClientUtils.exit(0);
            }
            if (arguments.numMessages > 0L && totalMessagesReceived.sum() >= arguments.numMessages) {
                log.info("------------- DONE (reached the maximum number: [{}] of consumption) --------------", (Object)arguments.numMessages);
                PerfClientUtils.exit(0);
            }
            messagesReceived.increment();
            bytesReceived.add(msg.getData().length);
            totalMessagesReceived.increment();
            totalBytesReceived.add(msg.getData().length);
            if (limiter != null) {
                limiter.acquire();
            }
            if ((latencyMillis = System.currentTimeMillis() - msg.getPublishTime()) >= 0L) {
                recorder.recordValue(latencyMillis);
                cumulativeRecorder.recordValue(latencyMillis);
            }
        };
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(arguments.serviceURL).connectionsPerBroker(arguments.maxConnections).statsInterval(arguments.statsIntervalSeconds, TimeUnit.SECONDS).ioThreads(arguments.ioThreads).listenerThreads(arguments.listenerThreads).enableTls(arguments.useTls).tlsTrustCertsFilePath(arguments.tlsTrustCertsFilePath);
        if (StringUtils.isNotBlank((CharSequence)arguments.authPluginClassName)) {
            clientBuilder.authentication(arguments.authPluginClassName, arguments.authParams);
        }
        if (arguments.tlsAllowInsecureConnection != null) {
            clientBuilder.allowTlsInsecureConnection(arguments.tlsAllowInsecureConnection.booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)arguments.listenerName)) {
            clientBuilder.listenerName(arguments.listenerName);
        }
        PulsarClient pulsarClient = clientBuilder.build();
        ArrayList futures = Lists.newArrayList();
        if ("earliest".equals(arguments.startMessageId)) {
            startMessageId = MessageId.earliest;
        } else if ("latest".equals(arguments.startMessageId)) {
            startMessageId = MessageId.latest;
        } else {
            String[] parts = arguments.startMessageId.split(":");
            startMessageId = new MessageIdImpl(Long.parseLong(parts[0]), Long.parseLong(parts[1]), -1);
        }
        ReaderBuilder readerBuilder = pulsarClient.newReader().readerListener((ReaderListener)listener).receiverQueueSize(arguments.receiverQueueSize).startMessageId(startMessageId);
        for (int i = 0; i < arguments.numTopics; ++i) {
            TopicName topicName = TopicName.get((String)arguments.topic.get(i));
            futures.add(readerBuilder.clone().topic(topicName.toString()).createAsync());
        }
        FutureUtil.waitForAll((List)futures).get();
        log.info("Start reading from {} topics", (Object)arguments.numTopics);
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceReader.printAggregatedThroughput(start);
            PerformanceReader.printAggregatedStats();
        }));
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesReceived.sum();
            double rate = (double)messagesReceived.sumThenReset() / elapsed;
            double throughput = (double)bytesReceived.sumThenReset() / elapsed * 8.0 / 1024.0 / 1024.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            log.info("Read throughput: {} msg --- {}  msg/s -- {} Mbit/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{intFormat.format(total), dec.format(rate), dec.format(throughput), dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getMaxValue()});
            reportHistogram.reset();
            oldTime = now;
        }
        pulsarClient.close();
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesReceived.sum() / elapsed;
        double throughput = (double)totalBytesReceived.sum() / elapsed * 8.0 / 1024.0 / 1024.0;
        log.info("Aggregated throughput stats --- {} records received --- {} msg/s --- {} Mbit/s", new Object[]{totalMessagesReceived, dec.format(rate), dec.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getValueAtPercentile(99.999), reportHistogram.getMaxValue()});
    }

    @Parameters(commandDescription="Test pulsar reader performance.")
    static class Arguments {
        @Parameter(names={"-h", "--help"}, description="Help message", help=true)
        boolean help;
        @Parameter(names={"--conf-file"}, description="Configuration file")
        public String confFile;
        @Parameter(description="persistent://prop/ns/my-topic", required=true)
        public List<String> topic;
        @Parameter(names={"-t", "--num-topics"}, description="Number of topics", validateWith={PositiveNumberParameterValidator.class})
        public int numTopics = 1;
        @Parameter(names={"-r", "--rate"}, description="Simulate a slow message reader (rate in msg/s)")
        public double rate = 0.0;
        @Parameter(names={"-m", "--start-message-id"}, description="Start message id. This can be either 'earliest', 'latest' or a specific message id by using 'lid:eid'")
        public String startMessageId = "earliest";
        @Parameter(names={"-q", "--receiver-queue-size"}, description="Size of the receiver queue")
        public int receiverQueueSize = 1000;
        @Parameter(names={"-n", "--num-messages"}, description="Number of messages to consume in total. If <= 0, it will keep consuming")
        public long numMessages = 0L;
        @Parameter(names={"-c", "--max-connections"}, description="Max number of TCP connections to a single broker")
        public int maxConnections = 100;
        @Parameter(names={"-i", "--stats-interval-seconds"}, description="Statistics Interval Seconds. If 0, statistics will be disabled")
        public long statsIntervalSeconds = 0L;
        @Parameter(names={"-u", "--service-url"}, description="Pulsar Service URL")
        public String serviceURL;
        @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name")
        public String authPluginClassName;
        @Parameter(names={"--listener-name"}, description="Listener name for the broker.")
        String listenerName = null;
        @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
        public String authParams;
        @Parameter(names={"--use-tls"}, description="Use TLS encryption on the connection")
        public boolean useTls;
        @Parameter(names={"--trust-cert-file"}, description="Path for the trusted TLS certificate file")
        public String tlsTrustCertsFilePath = "";
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure TLS connection")
        public Boolean tlsAllowInsecureConnection = null;
        @Parameter(names={"-time", "--test-duration"}, description="Test duration in secs. If <= 0, it will keep consuming")
        public long testTime = 0L;
        @Parameter(names={"-ioThreads", "--num-io-threads"}, description="Set the number of threads to be used for handling connections to brokers, default is 1 thread")
        public int ioThreads = 1;
        @Parameter(names={"-lt", "--num-listener-threads"}, description="Set the number of threads to be used for message listeners")
        public int listenerThreads = 1;

        Arguments() {
        }
    }
}

