/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.INDETERMINATE)
public final class ArrayIndeterminateOperator {
    private ArrayIndeterminateOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    public static boolean indeterminate(@OperatorDependency(operator=OperatorType.INDETERMINATE, argumentTypes={"T"}) MethodHandle elementIndeterminateFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @IsNull boolean isNull) {
        if (isNull) {
            return true;
        }
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                return true;
            }
            try {
                if (!elementIndeterminateFunction.invoke(TypeUtils.readNativeValue((Type)type, (Block)block, (int)i), false)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }
}

