/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.GrantInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class MetadataListing {
    private MetadataListing() {
    }

    public static SortedMap<String, CatalogName> listCatalogs(Session session, Metadata metadata, AccessControl accessControl) {
        Map<String, CatalogName> catalogNames = metadata.getCatalogNames(session);
        Set<String> allowedCatalogs = accessControl.filterCatalogs(session.getIdentity(), catalogNames.keySet());
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, CatalogName> entry : catalogNames.entrySet()) {
            if (!allowedCatalogs.contains(entry.getKey())) continue;
            result.put(entry);
        }
        return result.build();
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName) {
        ImmutableSet schemaNames = ImmutableSet.copyOf(metadata.listSchemaNames(session, catalogName));
        return ImmutableSortedSet.copyOf(accessControl.filterSchemas(session.toSecurityContext(), catalogName, (Set<String>)schemaNames));
    }

    public static Set<SchemaTableName> listTables(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listTables(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Set<SchemaTableName> listViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Map<SchemaTableName, ConnectorViewDefinition> getViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map views = (Map)metadata.getViews(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> accessible = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), views.keySet());
        return (Map)views.entrySet().stream().filter(entry -> accessible.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<GrantInfo> listTablePrivileges(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        List<GrantInfo> grants = metadata.listTablePrivileges(session, prefix);
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), (Set)grants.stream().map(GrantInfo::getSchemaTableName).collect(ImmutableSet.toImmutableSet()));
        return (Set)grants.stream().filter(grantInfo -> allowedTables.contains(grantInfo.getSchemaTableName())).collect(ImmutableSet.toImmutableSet());
    }

    public static Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map tableColumns = (Map)metadata.listTableColumns(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableColumns.keySet());
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry2 : tableColumns.entrySet()) {
            if (!allowedTables.contains(entry2.getKey())) continue;
            result.put(entry2.getKey(), accessControl.filterColumns(session.toSecurityContext(), new CatalogSchemaTableName(prefix.getCatalogName(), (SchemaTableName)entry2.getKey()), (List)entry2.getValue()));
        }
        return result.build();
    }
}

