/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.RowDecoderFactory;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class DispatchingRowDecoderFactory {
    private final Map<String, RowDecoderFactory> factories;

    @Inject
    public DispatchingRowDecoderFactory(Map<String, RowDecoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public RowDecoder create(String dataFormat, Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(dataFormat), (String)"unknown data format '%s'", (Object)dataFormat);
        return this.factories.get(dataFormat).create(decoderParams, columns);
    }
}

