/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolResolver;
import java.util.Map;
import java.util.Objects;

public class LookupSymbolResolver
implements SymbolResolver {
    private final Map<Symbol, ColumnHandle> assignments;
    private final Map<ColumnHandle, NullableValue> bindings;

    public LookupSymbolResolver(Map<Symbol, ColumnHandle> assignments, Map<ColumnHandle, NullableValue> bindings) {
        Objects.requireNonNull(assignments, "assignments is null");
        Objects.requireNonNull(bindings, "bindings is null");
        this.assignments = ImmutableMap.copyOf(assignments);
        this.bindings = ImmutableMap.copyOf(bindings);
    }

    @Override
    public Object getValue(Symbol symbol) {
        ColumnHandle column = this.assignments.get(symbol);
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Missing column assignment for %s", (Object)symbol);
        if (!this.bindings.containsKey(column)) {
            return symbol.toSymbolReference();
        }
        return this.bindings.get(column).getValue();
    }
}

