/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@ScalarFunction(value="shuffle", deterministic=false)
@Description(value="Generates a random permutation of the given array.")
public final class ArrayShuffleFunction {
    private final PageBuilder pageBuilder;
    private static final int INITIAL_LENGTH = 128;
    private int[] positions = new int[128];

    @TypeParameter(value="E")
    public ArrayShuffleFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block shuffle(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int i;
        int length = block.getPositionCount();
        if (this.positions.length < length) {
            this.positions = new int[length];
        }
        for (i = 0; i < length; ++i) {
            this.positions[i] = i;
        }
        for (i = length - 1; i > 0; --i) {
            int index = ThreadLocalRandom.current().nextInt(i + 1);
            int swap = this.positions[i];
            this.positions[i] = this.positions[index];
            this.positions[index] = swap;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i2 = 0; i2 < length; ++i2) {
            type.appendTo(block, this.positions[i2], blockBuilder);
        }
        this.pageBuilder.declarePositions(length);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - length, length);
    }
}

