/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;

public class OperatorCentroid2DLocal
extends OperatorCentroid2D {
    @Override
    public Point2D execute(Geometry geometry, ProgressTracker progressTracker) {
        if (geometry.isEmpty()) {
            return null;
        }
        Geometry.Type geometryType = geometry.getType();
        switch (geometryType) {
            case Point: {
                return ((Point)geometry).getXY();
            }
            case Line: {
                return OperatorCentroid2DLocal.computeLineCentroid((Line)geometry);
            }
            case Envelope: {
                return ((Envelope)geometry).getCenterXY();
            }
            case MultiPoint: {
                return OperatorCentroid2DLocal.computePointsCentroid((MultiPoint)geometry);
            }
            case Polyline: {
                return OperatorCentroid2DLocal.computePolylineCentroid((Polyline)geometry);
            }
            case Polygon: {
                return OperatorCentroid2DLocal.computePolygonCentroid((Polygon)geometry);
            }
        }
        throw new UnsupportedOperationException("Unexpected geometry type: " + (Object)((Object)geometryType));
    }

    private static Point2D computeLineCentroid(Line line) {
        return new Point2D((line.getEndX() - line.getStartX()) / 2.0, (line.getEndY() - line.getStartY()) / 2.0);
    }

    private static Point2D computePointsCentroid(MultiVertexGeometry multiPoint) {
        double xSum = 0.0;
        double ySum = 0.0;
        int pointCount = multiPoint.getPointCount();
        Point2D point2D = new Point2D();
        int i = 0;
        while (i < pointCount) {
            multiPoint.getXY(i, point2D);
            xSum += point2D.x;
            ySum += point2D.y;
            ++i;
        }
        return new Point2D(xSum / (double)pointCount, ySum / (double)pointCount);
    }

    /*
     * Unable to fully structure code
     */
    private static Point2D computePolylineCentroid(MultiPath polyline) {
        totalLength = polyline.calculateLength2D();
        if (totalLength == 0.0) {
            return OperatorCentroid2DLocal.computePointsCentroid(polyline);
        }
        xSum = new MathUtils.KahanSummator(0.0);
        ySum = new MathUtils.KahanSummator(0.0);
        point = new Point2D();
        iter = polyline.querySegmentIterator();
        ** GOTO lbl17
        {
            seg = iter.nextSegment();
            seg.getCoord2D(0.5, point);
            length = seg.calculateLength2D();
            point.scale(length);
            xSum.add(point.x);
            ySum.add(point.y);
            do {
                if (iter.hasNextSegment()) continue block0;
lbl17:
                // 2 sources

            } while (iter.nextPath());
        }
        return new Point2D(xSum.getResult() / totalLength, ySum.getResult() / totalLength);
    }

    private static Point2D computePolygonCentroid(Polygon polygon) {
        double totalArea = polygon.calculateArea2D();
        if (totalArea == 0.0) {
            return OperatorCentroid2DLocal.computePolylineCentroid(polygon);
        }
        MathUtils.KahanSummator xSum = new MathUtils.KahanSummator(0.0);
        MathUtils.KahanSummator ySum = new MathUtils.KahanSummator(0.0);
        Point2D startPoint = new Point2D();
        Point2D current = new Point2D();
        Point2D next = new Point2D();
        Point2D origin = polygon.getXY(0);
        int ipath = 0;
        int npaths = polygon.getPathCount();
        while (ipath < npaths) {
            int startIndex = polygon.getPathStart(ipath);
            int endIndex = polygon.getPathEnd(ipath);
            int pointCount = endIndex - startIndex;
            if (pointCount >= 3) {
                polygon.getXY(startIndex, startPoint);
                polygon.getXY(startIndex + 1, current);
                current.sub(startPoint);
                int i = startIndex + 2;
                int n = endIndex;
                while (i < n) {
                    polygon.getXY(i, next);
                    next.sub(startPoint);
                    double twiceTriangleArea = next.x * current.y - current.x * next.y;
                    xSum.add((current.x + next.x) * twiceTriangleArea);
                    ySum.add((current.y + next.y) * twiceTriangleArea);
                    current.setCoords(next);
                    ++i;
                }
                startPoint.sub(origin);
                startPoint.scale(6.0 * polygon.calculateRingArea2D(ipath));
                xSum.add(startPoint.x);
                ySum.add(startPoint.y);
            }
            ++ipath;
        }
        Point2D res = new Point2D(xSum.getResult() / (totalArea *= 6.0), ySum.getResult() / totalArea);
        res.add(origin);
        return res;
    }
}

