/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.Primitives;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Objects;

public final class NullableValue {
    private final Type type;
    private final Object value;
    private final MethodHandle equalOperator;
    private final MethodHandle hashCodeOperator;

    public NullableValue(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        if (value != null && !Primitives.wrap(type.getJavaType()).isInstance(value)) {
            throw new IllegalArgumentException(String.format("Object '%s' does not match type %s", value, type.getJavaType()));
        }
        this.type = type;
        this.value = value;
        if (type.isComparable()) {
            this.equalOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL)).asType(MethodType.methodType(Boolean.class, Object.class, Object.class));
            this.hashCodeOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL)).asType(MethodType.methodType(Long.TYPE, Object.class));
        } else {
            this.equalOperator = null;
            this.hashCodeOperator = null;
        }
    }

    public static NullableValue of(Type type, Object value) {
        Objects.requireNonNull(value, "value is null");
        return new NullableValue(type, value);
    }

    public static NullableValue asNull(Type type) {
        return new NullableValue(type, null);
    }

    @JsonCreator
    public static NullableValue fromSerializable(@JsonProperty(value="serializable") Serializable serializable) {
        Type type = serializable.getType();
        Block block = serializable.getBlock();
        return new NullableValue(type, block == null ? null : Utils.blockToNativeValue(type, block));
    }

    @JsonProperty
    public Serializable getSerializable() {
        return new Serializable(this.type, this.value == null ? null : Utils.nativeValueToBlock(this.type, this.value));
    }

    public Block asBlock() {
        return Utils.nativeValueToBlock(this.type, this.value);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        long hash = Objects.hash(this.type);
        if (this.value != null) {
            hash = hash * 31L + this.valueHash();
        }
        return (int)hash;
    }

    private long valueHash() {
        try {
            return this.hashCodeOperator.invokeExact(this.value);
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NullableValue other = (NullableValue)obj;
        return Objects.equals(this.type, other.type) && this.value == null == (other.value == null) && (this.value == null || this.valueEquals(other.value));
    }

    private boolean valueEquals(Object otherValue) {
        try {
            return this.equalOperator.invokeExact(this.value, otherValue) == Boolean.TRUE;
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NullableValue{");
        sb.append("type=").append(this.type);
        sb.append(", value=").append(this.type.getObjectValue(ToStringSession.INSTANCE, Utils.nativeValueToBlock(this.type, this.value), 0));
        sb.append('}');
        return sb.toString();
    }

    public static class Serializable {
        private final Type type;
        private final Block block;

        @JsonCreator
        public Serializable(@JsonProperty(value="type") Type type, @JsonProperty(value="block") Block block) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.block = block;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public Block getBlock() {
            return this.block;
        }
    }
}

