/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Optional;

public class ReplaceWindowWithRowNumber
implements Rule<WindowNode> {
    private final Pattern<WindowNode> pattern = Patterns.window().matching(window -> {
        if (window.getWindowFunctions().size() != 1) {
            return false;
        }
        BoundSignature signature = ((WindowNode.Function)Iterables.getOnlyElement(window.getWindowFunctions().values())).getResolvedFunction().getSignature();
        return signature.getArgumentTypes().isEmpty() && signature.getName().equals("row_number");
    }).matching(window -> window.getOrderingScheme().isEmpty());

    public ReplaceWindowWithRowNumber(Metadata metadata) {
    }

    @Override
    public Pattern<WindowNode> getPattern() {
        return this.pattern;
    }

    @Override
    public Rule.Result apply(WindowNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), false, (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty()));
    }
}

