/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneUnnestColumns
extends ProjectOffPushDownRule<UnnestNode> {
    public PruneUnnestColumns() {
        super(Patterns.unnest());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, UnnestNode unnestNode, Set<Symbol> referencedOutputs) {
        ImmutableSet.Builder referencedAndFilterSymbolsBuilder = ImmutableSet.builder().addAll(referencedOutputs);
        unnestNode.getFilter().ifPresent(expression -> referencedAndFilterSymbolsBuilder.addAll(SymbolsExtractor.extractUnique(expression)));
        ImmutableSet referencedAndFilterSymbols = referencedAndFilterSymbolsBuilder.build();
        List prunedReplicateSymbols = (List)unnestNode.getReplicateSymbols().stream().filter(((Set)referencedAndFilterSymbols)::contains).collect(ImmutableList.toImmutableList());
        Optional<Symbol> prunedOrdinalitySymbol = unnestNode.getOrdinalitySymbol().filter(((Set)referencedAndFilterSymbols)::contains);
        if (prunedReplicateSymbols.size() == unnestNode.getReplicateSymbols().size() && prunedOrdinalitySymbol.equals(unnestNode.getOrdinalitySymbol())) {
            return Optional.empty();
        }
        return Optional.of(new UnnestNode(unnestNode.getId(), unnestNode.getSource(), prunedReplicateSymbols, unnestNode.getMappings(), prunedOrdinalitySymbol, unnestNode.getJoinType(), unnestNode.getFilter()));
    }
}

