/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneIndexSourceColumns
extends ProjectOffPushDownRule<IndexSourceNode> {
    public PruneIndexSourceColumns() {
        super(Patterns.indexSource());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, IndexSourceNode indexSourceNode, Set<Symbol> referencedOutputs) {
        Set prunedLookupSymbols = (Set)indexSourceNode.getLookupSymbols().stream().filter(referencedOutputs::contains).collect(ImmutableSet.toImmutableSet());
        Map prunedAssignments = Maps.filterEntries(indexSourceNode.getAssignments(), entry -> referencedOutputs.contains(entry.getKey()));
        List prunedOutputList = (List)indexSourceNode.getOutputSymbols().stream().filter(referencedOutputs::contains).collect(ImmutableList.toImmutableList());
        return Optional.of(new IndexSourceNode(indexSourceNode.getId(), indexSourceNode.getIndexHandle(), indexSourceNode.getTableHandle(), prunedLookupSymbols, prunedOutputList, prunedAssignments));
    }
}

