/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.RuleStats;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RuleStatsRecorder {
    private final Map<Class<?>, RuleStats> stats = new HashMap();

    public void registerAll(Collection<Rule<?>> rules) {
        for (Rule<?> rule : rules) {
            Preconditions.checkArgument((!rule.getClass().isAnonymousClass() ? 1 : 0) != 0);
            this.stats.put(rule.getClass(), new RuleStats());
        }
    }

    public void record(Rule<?> rule, long nanos, boolean match) {
        this.stats.get(rule.getClass()).record(nanos, match);
    }

    public void recordFailure(Rule<?> rule) {
        this.stats.get(rule.getClass()).recordFailure();
    }

    public Map<Class<?>, RuleStats> getStats() {
        return ImmutableMap.copyOf(this.stats);
    }
}

