/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static Expression createDynamicFilterExpression(Session session, Metadata metadata, DynamicFilterId id, Type inputType, SymbolReference input, ComparisonExpression.Operator operator, boolean nullAllowed) {
        return DynamicFilters.createDynamicFilterExpression(session, metadata, id, inputType, (Expression)input, operator, nullAllowed);
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Session session, Metadata metadata, DynamicFilterId id, Type inputType, Expression input, ComparisonExpression.Operator operator) {
        return DynamicFilters.createDynamicFilterExpression(session, metadata, id, inputType, input, operator, false);
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Session session, Metadata metadata, DynamicFilterId id, Type inputType, Expression input, ComparisonExpression.Operator operator, boolean nullAllowed) {
        return FunctionCallBuilder.resolve(session, metadata).setName(QualifiedName.of((String)(nullAllowed ? "$internal$dynamic_filter_nullable_function" : "$internal$dynamic_filter_function"))).addArgument(inputType, input).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(operator.toString())).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(id.toString())).addArgument((Type)BooleanType.BOOLEAN, (Expression)(nullAllowed ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
    }

    @VisibleForTesting
    public static Expression createDynamicFilterExpression(Session session, Metadata metadata, DynamicFilterId id, Type inputType, Expression input) {
        return DynamicFilters.createDynamicFilterExpression(session, metadata, id, inputType, input, ComparisonExpression.Operator.EQUAL);
    }

    public static ExtractResult extractDynamicFilters(Expression expression) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (Expression conjunct : conjuncts) {
            Optional<Descriptor> descriptor = DynamicFilters.getDescriptor(conjunct);
            if (descriptor.isPresent()) {
                dynamicConjuncts.add((Object)descriptor.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new ExtractResult((List<Expression>)staticConjuncts.build(), (List<Descriptor>)dynamicConjuncts.build());
    }

    public static Multimap<DynamicFilterId, Descriptor> extractSourceSymbols(List<Descriptor> dynamicFilters) {
        return (Multimap)dynamicFilters.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Descriptor::getId, descriptor -> new Descriptor(descriptor.getId(), (Expression)DynamicFilters.extractSourceSymbol(descriptor).toSymbolReference(), descriptor.getOperator(), descriptor.isNullAllowed())));
    }

    private static Symbol extractSourceSymbol(Descriptor descriptor) {
        Expression dynamicFilterExpression = descriptor.getInput();
        if (dynamicFilterExpression instanceof SymbolReference) {
            return Symbol.from(dynamicFilterExpression);
        }
        Preconditions.checkState((boolean)(dynamicFilterExpression instanceof Cast));
        Preconditions.checkState((boolean)(((Cast)dynamicFilterExpression).getExpression() instanceof SymbolReference));
        return Symbol.from(((Cast)dynamicFilterExpression).getExpression());
    }

    public static Expression replaceDynamicFilterId(FunctionCall dynamicFilterFunctionCall, DynamicFilterId newId) {
        return new FunctionCall(dynamicFilterFunctionCall.getLocation(), dynamicFilterFunctionCall.getName(), dynamicFilterFunctionCall.getWindow(), dynamicFilterFunctionCall.getFilter(), dynamicFilterFunctionCall.getOrderBy(), dynamicFilterFunctionCall.isDistinct(), dynamicFilterFunctionCall.getNullTreatment(), dynamicFilterFunctionCall.getProcessingMode(), (List)ImmutableList.of((Object)((Expression)dynamicFilterFunctionCall.getArguments().get(0)), (Object)((Expression)dynamicFilterFunctionCall.getArguments().get(1)), (Object)new StringLiteral(newId.toString()), (Object)((Expression)dynamicFilterFunctionCall.getArguments().get(3))));
    }

    public static boolean isDynamicFilter(Expression expression) {
        return DynamicFilters.getDescriptor(expression).isPresent();
    }

    public static Optional<Descriptor> getDescriptor(Expression expression) {
        if (!(expression instanceof FunctionCall)) {
            return Optional.empty();
        }
        FunctionCall functionCall = (FunctionCall)expression;
        if (!DynamicFilters.isDynamicFilterFunction(functionCall)) {
            return Optional.empty();
        }
        List arguments = functionCall.getArguments();
        Preconditions.checkArgument((arguments.size() == 4 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        Expression probeSymbol = (Expression)arguments.get(0);
        Expression operatorExpression = (Expression)arguments.get(1);
        Preconditions.checkArgument((boolean)(operatorExpression instanceof StringLiteral), (String)"operatorExpression is expected to be an instance of StringLiteral: %s", (Object)operatorExpression.getClass().getSimpleName());
        String operatorExpressionString = ((StringLiteral)operatorExpression).getValue();
        ComparisonExpression.Operator operator = ComparisonExpression.Operator.valueOf((String)operatorExpressionString);
        Expression idExpression = (Expression)arguments.get(2);
        Preconditions.checkArgument((boolean)(idExpression instanceof StringLiteral), (String)"id is expected to be an instance of StringLiteral: %s", (Object)idExpression.getClass().getSimpleName());
        String id = ((StringLiteral)idExpression).getValue();
        Expression nullAllowedExpression = (Expression)arguments.get(3);
        Preconditions.checkArgument((boolean)(nullAllowedExpression instanceof BooleanLiteral), (String)"nullAllowedExpression is expected to be an instance of BooleanLiteral: %s", (Object)nullAllowedExpression.getClass().getSimpleName());
        boolean nullAllowed = ((BooleanLiteral)nullAllowedExpression).getValue();
        return Optional.of(new Descriptor(new DynamicFilterId(id), probeSymbol, operator, nullAllowed));
    }

    private static boolean isDynamicFilterFunction(FunctionCall functionCall) {
        String functionName = ResolvedFunction.extractFunctionName(functionCall.getName());
        return functionName.equals("$internal$dynamic_filter_function") || functionName.equals("$internal$dynamic_filter_nullable_function");
    }

    @ScalarFunction(value="$internal$dynamic_filter_nullable_function", hidden=true)
    public static final class NullableFunction {
        private static final String NAME = "$internal$dynamic_filter_nullable_function";

        private NullableFunction() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Object input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @IsNull boolean inputNull, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", hidden=true)
    public static final class Function {
        private static final String NAME = "$internal$dynamic_filter_function";

        private Function() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") Object input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") long input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") boolean input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="T") double input, @SqlType(value="varchar") Slice operator, @SqlType(value="varchar") Slice id, @SqlType(value="boolean") boolean nullAllowed) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Descriptor {
        private final DynamicFilterId id;
        private final Expression input;
        private final ComparisonExpression.Operator operator;
        private final boolean nullAllowed;

        public Descriptor(DynamicFilterId id, Expression input, ComparisonExpression.Operator operator, boolean nullAllowed) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
            Preconditions.checkArgument((!nullAllowed || operator == ComparisonExpression.Operator.EQUAL ? 1 : 0) != 0, (Object)"nullAllowed should be true only with EQUAL operator");
            this.nullAllowed = nullAllowed;
        }

        public Descriptor(DynamicFilterId id, Expression input, ComparisonExpression.Operator operator) {
            this(id, input, operator, false);
        }

        public Descriptor(DynamicFilterId id, Expression input) {
            this(id, input, ComparisonExpression.Operator.EQUAL);
        }

        public DynamicFilterId getId() {
            return this.id;
        }

        public Expression getInput() {
            return this.input;
        }

        public ComparisonExpression.Operator getOperator() {
            return this.operator;
        }

        public boolean isNullAllowed() {
            return this.nullAllowed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input) && Objects.equals(this.operator, that.operator) && this.nullAllowed == that.nullAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.input, this.operator, this.nullAllowed);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).add("operator", (Object)this.operator).add("nullAllowed", this.nullAllowed).toString();
        }

        public Domain applyComparison(Domain domain) {
            if (domain.isAll()) {
                return domain;
            }
            if (domain.isNone()) {
                if (this.nullAllowed) {
                    return Domain.onlyNull((Type)domain.getType());
                }
                return domain;
            }
            Range span = domain.getValues().getRanges().getSpan();
            switch (this.operator) {
                case EQUAL: {
                    if (this.nullAllowed) {
                        return Domain.create((ValueSet)domain.getValues(), (boolean)true);
                    }
                    return domain;
                }
                case LESS_THAN: {
                    Range range = Range.lessThan((Type)span.getType(), (Object)span.getHighBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    Range range = Range.lessThanOrEqual((Type)span.getType(), (Object)span.getHighBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN: {
                    Range range = Range.greaterThan((Type)span.getType(), (Object)span.getLowBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Range range = Range.greaterThanOrEqual((Type)span.getType(), (Object)span.getLowBoundedValue());
                    return Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
                }
            }
            throw new IllegalArgumentException("Unsupported dynamic filtering comparison operator: " + this.operator);
        }
    }

    public static class ExtractResult {
        private final List<Expression> staticConjuncts;
        private final List<Descriptor> dynamicConjuncts;

        public ExtractResult(List<Expression> staticConjuncts, List<Descriptor> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<Expression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<Descriptor> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }
}

