/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.execution.TaskId;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class RemoteSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RemoteSplit.class).instanceSize();
    private final TaskId taskId;
    private final String location;

    @JsonCreator
    public RemoteSplit(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="location") String location) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    @JsonProperty
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("location", (Object)this.location).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.taskId.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
    }
}

