/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@Description(value="Last day of the month of the given timestamp")
@ScalarFunction(value="last_day_of_month")
public class LastDayOfMonth {
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private LastDayOfMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return LastDayOfMonth.lastDayOfMonth(DateTimeZoneIndex.unpackChronology(packedEpochMillis), DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return LastDayOfMonth.lastDayOfMonth(DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), timestamp.getEpochMillis());
    }

    private static long lastDayOfMonth(ISOChronology chronology, long millis) {
        millis = chronology.monthOfYear().roundCeiling(millis + 1L);
        millis = chronology.getZone().convertUTCToLocal(millis) - 86400000L;
        return TimeUnit.MILLISECONDS.toDays(millis);
    }
}

