/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@Description(value="Difference of the given times in the given unit")
@ScalarFunction(value="date_diff")
public class DateDiff {
    private DateDiff() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") long timestamp1, @SqlType(value="timestamp(p)") long timestamp2) {
        long epochMillis1 = DateTimes.scaleEpochMicrosToMillis(timestamp1);
        long epochMillis2 = DateTimes.scaleEpochMicrosToMillis(timestamp2);
        return DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).getDifferenceAsLong(epochMillis2, epochMillis1);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") LongTimestamp timestamp1, @SqlType(value="timestamp(p)") LongTimestamp timestamp2) {
        return DateDiff.diff(unit, timestamp1.getEpochMicros(), timestamp2.getEpochMicros());
    }
}

