/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.BooleanDistinctState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="approx_distinct")
public final class BooleanApproximateCountDistinctAggregation {
    private BooleanApproximateCountDistinctAggregation() {
    }

    @InputFunction
    public static void input(BooleanDistinctState state, @SqlType(value="boolean") boolean value, @SqlType(value="double") double maxStandardError) {
        byte newState = (byte)(state.getByte() | (value ? 1 : 2));
        state.setByte(newState);
    }

    @CombineFunction
    public static void combineState(BooleanDistinctState state, BooleanDistinctState otherState) {
        state.setByte((byte)(state.getByte() | otherState.getByte()));
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(BooleanDistinctState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, (long)Integer.bitCount(state.getByte()));
    }
}

