/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.metadata.TypeVariables;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

class BoundVariables
implements TypeVariables {
    private final Map<String, Type> typeVariables = new TreeMap<String, Type>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Long> longVariables = new TreeMap<String, Long>(String.CASE_INSENSITIVE_ORDER);

    BoundVariables() {
    }

    @Override
    public Type getTypeVariable(String variableName) {
        return BoundVariables.getValue(this.typeVariables, variableName);
    }

    public BoundVariables setTypeVariable(String variableName, Type variableValue) {
        BoundVariables.setValue(this.typeVariables, variableName, variableValue);
        return this;
    }

    @Override
    public boolean containsTypeVariable(String variableName) {
        return BoundVariables.containsValue(this.typeVariables, variableName);
    }

    public Map<String, Type> getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public Long getLongVariable(String variableName) {
        return BoundVariables.getValue(this.longVariables, variableName);
    }

    public BoundVariables setLongVariable(String variableName, Long variableValue) {
        BoundVariables.setValue(this.longVariables, variableName, variableValue);
        return this;
    }

    @Override
    public boolean containsLongVariable(String variableName) {
        return BoundVariables.containsValue(this.longVariables, variableName);
    }

    public Map<String, Long> getLongVariables() {
        return this.longVariables;
    }

    private static <T> T getValue(Map<String, T> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        T value = map.get(variableName);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is null", (Object)variableName);
        return value;
    }

    private static boolean containsValue(Map<String, ?> map, String variableName) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        return map.containsKey(variableName);
    }

    private static <T> void setValue(Map<String, T> map, String variableName, T value) {
        Preconditions.checkState((variableName != null ? 1 : 0) != 0, (Object)"variableName is null");
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is null", (Object)variableName);
        map.put(variableName, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundVariables that = (BoundVariables)o;
        return Objects.equals(this.typeVariables, that.typeVariables) && Objects.equals(this.longVariables, that.longVariables);
    }

    public int hashCode() {
        return Objects.hash(this.typeVariables, this.longVariables);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeVariables", this.typeVariables).add("longVariables", this.longVariables).toString();
    }
}

