/*
 * Decompiled with CFR 0.152.
 */
package io.trino.index;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.IndexHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IndexManager {
    private final ConcurrentMap<CatalogName, ConnectorIndexProvider> providers = new ConcurrentHashMap<CatalogName, ConnectorIndexProvider>();

    public void addIndexProvider(CatalogName catalogName, ConnectorIndexProvider indexProvider) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(indexProvider, "indexProvider is null");
        Preconditions.checkState((this.providers.putIfAbsent(catalogName, indexProvider) == null ? 1 : 0) != 0, (String)"IndexProvider for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeIndexProvider(CatalogName catalogName) {
        this.providers.remove(catalogName);
    }

    public ConnectorIndex getIndex(Session session, IndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        ConnectorSession connectorSession = session.toConnectorSession(indexHandle.getCatalogName());
        ConnectorIndexProvider provider = this.getProvider(indexHandle);
        return provider.getIndex(indexHandle.getTransactionHandle(), connectorSession, indexHandle.getConnectorHandle(), lookupSchema, outputSchema);
    }

    private ConnectorIndexProvider getProvider(IndexHandle handle) {
        ConnectorIndexProvider result = (ConnectorIndexProvider)this.providers.get(handle.getCatalogName());
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No index provider for connector '%s'", (Object)handle.getCatalogName());
        return result;
    }
}

