/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.QueryTracker;
import io.trino.execution.StageId;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.warnings.WarningCollector;
import io.trino.memory.VersionedMemoryPoolId;
import io.trino.server.BasicQueryInfo;
import io.trino.server.protocol.Slug;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public interface QueryExecution
extends QueryTracker.TrackedQuery {
    public QueryState getState();

    public ListenableFuture<QueryState> getStateChange(QueryState var1);

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> var1);

    public void addOutputInfoListener(Consumer<QueryOutputInfo> var1);

    public void outputTaskFailed(TaskId var1, Throwable var2);

    public Plan getQueryPlan();

    public BasicQueryInfo getBasicQueryInfo();

    public QueryInfo getQueryInfo();

    public Slug getSlug();

    public Duration getTotalCpuTime();

    public DataSize getUserMemoryReservation();

    public DataSize getTotalMemoryReservation();

    public VersionedMemoryPoolId getMemoryPool();

    public void setMemoryPool(VersionedMemoryPoolId var1);

    public void start();

    public void cancelQuery();

    public void cancelStage(StageId var1);

    public void recordHeartbeat();

    public boolean shouldWaitForMinWorkers();

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> var1);

    public static class QueryOutputInfo {
        private final List<String> columnNames;
        private final List<Type> columnTypes;
        private final Map<TaskId, URI> bufferLocations;
        private final boolean noMoreBufferLocations;

        public QueryOutputInfo(List<String> columnNames, List<Type> columnTypes, Map<TaskId, URI> bufferLocations, boolean noMoreBufferLocations) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.bufferLocations = ImmutableMap.copyOf(Objects.requireNonNull(bufferLocations, "bufferLocations is null"));
            this.noMoreBufferLocations = noMoreBufferLocations;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }

        public Map<TaskId, URI> getBufferLocations() {
            return this.bufferLocations;
        }

        public boolean isNoMoreBufferLocations() {
            return this.noMoreBufferLocations;
        }
    }

    public static interface QueryExecutionFactory<T extends QueryExecution> {
        public T createQueryExecution(QueryPreparer.PreparedQuery var1, QueryStateMachine var2, Slug var3, WarningCollector var4);
    }
}

